<?php

namespace App\Console\Commands;

use App\Models\Carteira;
use Illuminate\Console\Command;

class ResetAdminPassword extends Command
{
    /**
     * The name and signature of the console command.
     *
     * @var string
     */
    protected $signature = 'admin:reset-password {email?} {password?}';

    /**
     * The console command description.
     *
     * @var string
     */
    protected $description = 'Reseta a senha de um usuário admin';

    /**
     * Execute the console command.
     */
    public function handle()
    {
        $email = $this->argument('email') ?? 'admin@admin.com';
        $password = $this->argument('password') ?? 'admin123';
        
        $admin = Carteira::where('login', $email)->first();
        
        if (!$admin) {
            $this->error("❌ Usuário com email '{$email}' não encontrado!");
            return 1;
        }
        
        $admin->update([
            'senha' => sha1($password),
            'tipo' => '1', // Garante que é admin
            'status' => '1', // Garante que está ativo
        ]);
        
        $this->info('✅ Senha resetada com sucesso!');
        $this->info("📧 Login: {$email}");
        $this->info("🔑 Senha: {$password}");
        $this->info("👤 Tipo: " . ($admin->tipo == '1' ? 'Admin' : ($admin->tipo == '2' ? 'Revendedor' : 'Usuário')));
        
        return 0;
    }
}
