<?php

namespace App\Http\Middleware;

use Closure;
use Illuminate\Http\Request;
use Carbon\Carbon;
use Illuminate\Support\Facades\Auth;
use Symfony\Component\HttpFoundation\Response;

class CheckSubscription
{
    /**
     * Handle an incoming request.
     */
    public function handle(Request $request, Closure $next): Response
    {
        $user = Auth::user();

        // Admin Master não precisa verificar
        if ($user->tipo == '1') {
            return $next($request);
        }

        // Revendedor não precisa verificar
        if ($user->tipo == '2') {
            return $next($request);
        }

        // Verifica data de expiração
        if ($user->assinatura) {
            try {
                $assinatura = Carbon::createFromFormat('d/m/Y', $user->assinatura);
                $hoje = Carbon::now();

                if ($hoje->greaterThan($assinatura)) {
                    // Assinatura expirada
                    if (!$request->is('master/planos*') && !$request->is('sair')) {
                        return redirect()->route('planos.index')
                            ->with('warning', 'Sua assinatura expirou. Renove para continuar.');
                    }
                }
            } catch (\Exception $e) {
                // Data inválida
            }
        }

        return $next($request);
    }
}

