<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Foundation\Auth\User as Authenticatable;

class Carteira extends Authenticatable
{
    use HasFactory;

    protected $table = 'carteira';
    
    protected $primaryKey = 'Id';
    
    public $incrementing = true;

    protected $fillable = [
        'Id',
        'idm',
        'valor',
        'vjurus',
        'login',
        'senha',
        'tipo',
        'roles',
        'status',
        'nome',
        'celular',
        'nascimento',
        'cpf',
        'email',
        'cep',
        'endereco',
        'numero',
        'bairro',
        'complemento',
        'cidade',
        'uf',
        'tokenmp',
        'tokenasaas',
        'publicmp',
        'client_id_asaas',
        'gerecianet_client',
        'gerecianet_secret',
        'certificado_pem',
        'chave_pix',
        'key_paghiper',
        'token_paghiper',
        'nomecom',
        'cnpj',
        'enderecom',
        'contato',
        'msg',
        'msgqr',
        'msgpix',
        'tokenapi',
        'pagamentos',
        'assinatura',
        'background',
        'juros_diarios',
        'favicon',
        'whatsapp_api',
        'whatsapp_token',
        'pix_manual_key',
        'premium_zap_name',
        'premium_zap_token',
        'premium_zap_checkbox',
        'cob_brasil',
        'client_id_brasil',
        'client_secret_brasil',
        'convenio_brasil',
        'carteira_brasil',
        'variacao_brasil',
        'cadastros_lim',
        'plano_id',
        'nao_cobrar_fim_semana',
        'whatsapp_api_2',
        'whatsapp_token_2',
        'servidor_1_ativo',
        'servidor_2_ativo',
        'mensagem_ajuda',
        'servidor_1_limite',
        'servidor_2_limite',
    ];

    protected $hidden = [
        'senha',
    ];

    protected $casts = [
        'juros_diarios' => 'decimal:2',
        'created_at' => 'datetime',
        'updated_at' => 'datetime',
    ];

    // Relacionamentos
    public function categorias()
    {
        return $this->hasMany(Categoria::class, 'idu', 'id');
    }

    public function clientes()
    {
        return $this->hasMany(Cliente::class, 'idm', 'id');
    }

    public function financeiro1()
    {
        return $this->hasMany(Financeiro1::class, 'idm', 'id');
    }

    public function financeiro2()
    {
        return $this->hasMany(Financeiro2::class, 'idm', 'id');
    }

    public function financeiro3()
    {
        return $this->hasMany(Financeiro3::class, 'idm', 'id');
    }

    public function mensagens()
    {
        return $this->hasMany(Mensagem::class, 'idm', 'id');
    }

    public function logs()
    {
        return $this->hasMany(Log::class, 'idm', 'id');
    }

    // Métodos auxiliares
    public function isAdmin(): bool
    {
        return $this->tipo == '1';
    }

    public function isRevendedor(): bool
    {
        return $this->tipo == '2';
    }

    public function isActive(): bool
    {
        return $this->status == '1';
    }

    /**
     * Get the password for the user.
     */
    public function getAuthPassword()
    {
        return $this->senha;
    }
}

