<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class Conexao extends Model
{
    use HasFactory;

    protected $table = 'conexoes';

    protected $fillable = [
        'id_usuario',
        'qrcode',
        'conn',
        'apikey',
    ];

    protected $casts = [
        'id_usuario' => 'integer',
        'created_at' => 'datetime',
        'updated_at' => 'datetime',
    ];

    // Relacionamentos
    public function carteira()
    {
        return $this->belongsTo(Carteira::class, 'id_usuario', 'id');
    }

    // Métodos auxiliares
    public function isConectado(): bool
    {
        return $this->conn == '1';
    }
}

