<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use Carbon\Carbon;

class Financeiro2 extends Model
{
    use HasFactory;

    protected $table = 'financeiro2';

    protected $fillable = [
        'idc',
        'idm',
        'chave',
        'parcela',
        'datapagamento',
        'pagoem',
        'status',
        'tempo',
        'temp5',
        'temp3',
        'temp0',
        'obsv',
        'juros_calculados',
        'taxa_juros_diaria',
        'dias_vencidos',
        'gatewayPayment',
    ];

    protected $casts = [
        'parcela' => 'decimal:2',
        'taxa_juros_diaria' => 'decimal:2',
        'juros_calculados' => 'integer',
        'dias_vencidos' => 'integer',
        'gatewayPayment' => 'integer',
        'created_at' => 'datetime',
        'updated_at' => 'datetime',
    ];

    // Relacionamentos
    public function carteira()
    {
        return $this->belongsTo(Carteira::class, 'idm', 'id');
    }

    public function cliente()
    {
        return $this->belongsTo(Cliente::class, 'idc', 'id');
    }

    public function cobranca()
    {
        return $this->belongsTo(Financeiro1::class, 'chave', 'chave');
    }

    public function financeiro1()
    {
        return $this->belongsTo(Financeiro1::class, 'chave', 'chave');
    }

    // Métodos auxiliares
    public function isAberto(): bool
    {
        return $this->status == '1';
    }

    public function isPago(): bool
    {
        return $this->status == '2';
    }

    public function isVencido(): bool
    {
        if ($this->datapagamento == 'n' || empty($this->datapagamento)) {
            return false;
        }
        
        try {
            $vencimento = Carbon::createFromFormat('d/m/Y', $this->datapagamento);
            return Carbon::now()->greaterThan($vencimento) && $this->isAberto();
        } catch (\Exception $e) {
            return false;
        }
    }

    public function calcularDiasVencidos(): int
    {
        if (!$this->isVencido()) {
            return 0;
        }

        try {
            $vencimento = Carbon::createFromFormat('d/m/Y', $this->datapagamento);
            return Carbon::now()->diffInDays($vencimento);
        } catch (\Exception $e) {
            return 0;
        }
    }
}

