<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class Financeiro3 extends Model
{
    use HasFactory;

    protected $table = 'financeiro3';

    protected $fillable = [
        'idm',
        'dataentrada',
        'valor',
        'datavencimento',
        'datapagamento',
        'status',
        'descricao',
        'observacao',
        'tipo',
        'categoria',
        'categoria_id',
        'recorrente',
        'frequencia',
        'data_final',
        'origem_recorrente_id',
    ];

    protected $casts = [
        'valor' => 'decimal:2',
        'created_at' => 'datetime',
        'updated_at' => 'datetime',
    ];

    // Relacionamentos
    public function carteira()
    {
        return $this->belongsTo(Carteira::class, 'idm', 'id');
    }

    // Métodos auxiliares
    public function isAberto(): bool
    {
        return $this->status == '0'; // 0 = Pendente/Aberto
    }

    public function isPago(): bool
    {
        return $this->status == '1'; // 1 = Pago
    }
}

