<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class PagamentoFun extends Model
{
    use HasFactory;

    protected $table = 'pagamentofun';

    protected $fillable = [
        'idm',
        'idf',
        'valor',
        'status',
    ];

    protected $casts = [
        'idm' => 'integer',
        'idf' => 'integer',
        'valor' => 'decimal:2',
        'created_at' => 'datetime',
        'updated_at' => 'datetime',
    ];

    // Relacionamentos
    public function carteira()
    {
        return $this->belongsTo(Carteira::class, 'idm', 'id');
    }
}

