<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Relations\BelongsTo;

class PdvFormaPagamento extends Model
{
    use HasFactory;

    protected $table = '_pdv_formas_pagamento';

    protected $fillable = [
        'idm',
        'nome',
    ];

    /**
     * Relacionamento com usuário (Carteira)
     */
    public function usuario(): BelongsTo
    {
        return $this->belongsTo(Carteira::class, 'idm', 'id');
    }
}

