<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Relations\BelongsTo;

class PdvItem extends Model
{
    use HasFactory;

    protected $table = '_pdv_itens';

    protected $fillable = [
        'id_venda',
        'id_produto',
        'quantidade',
        'preco_unitario',
        'subtotal',
    ];

    protected $casts = [
        'quantidade' => 'integer',
        'preco_unitario' => 'decimal:2',
        'subtotal' => 'decimal:2',
    ];

    /**
     * Relacionamento com venda
     */
    public function venda(): BelongsTo
    {
        return $this->belongsTo(PdvVenda::class, 'id_venda');
    }

    /**
     * Relacionamento com produto
     */
    public function produto(): BelongsTo
    {
        return $this->belongsTo(PdvProduto::class, 'id_produto');
    }

    /**
     * Calcula o subtotal automaticamente
     */
    public function calcularSubtotal(): float
    {
        return $this->quantidade * $this->preco_unitario;
    }
}

