<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('financeiro1', function (Blueprint $table) {
            $table->id();
            $table->string('idc', 5)->default('n'); // ID do cliente
            $table->string('idm', 9)->nullable(); // ID do usuário (carteira)
            $table->string('idcob', 5)->default('n');
            $table->decimal('valorsolicitado', 10, 2)->default(0.00);
            $table->string('taxaj', 5)->default('n');
            $table->decimal('valorjurus', 10, 2)->default(0.00);
            $table->decimal('valorfinal', 10, 2)->nullable();
            $table->string('formapagamento', 3)->default('n');
            $table->string('parcelas', 3)->default('n');
            $table->string('primeiraparcela', 20)->default('n');
            $table->string('chave', 60)->default('n'); // Chave única para relacionar com parcelas
            $table->string('status', 2)->default('1');
            $table->decimal('vparcela', 10, 2)->default(0.00);
            $table->string('pagoem', 255)->default('n');
            $table->string('entrada', 15)->default('n');
            $table->integer('gatewayPayment')->default(1);
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('financeiro1');
    }
};

