<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('financeiro2', function (Blueprint $table) {
            $table->id();
            $table->string('idc', 9)->nullable(); // ID do cliente
            $table->string('idm', 9)->nullable(); // ID do usuário (carteira)
            $table->string('chave', 60)->default('n'); // Chave para relacionar com financeiro1
            $table->decimal('parcela', 10, 2)->default(0.00);
            $table->string('datapagamento', 20)->default('n'); // Data de vencimento
            $table->string('pagoem', 20)->default('n'); // Data que foi pago
            $table->string('status', 2)->default('1'); // 1=Aberto, 2=Pago
            $table->string('tempo', 2)->default('2'); // Controle de notificações
            $table->string('temp5', 2)->default('2');
            $table->string('temp3', 2)->default('2');
            $table->string('temp0', 2)->default('2');
            $table->text('obsv')->nullable();
            $table->integer('juros_calculados')->default(0);
            $table->decimal('taxa_juros_diaria', 10, 2)->default(0.00);
            $table->integer('dias_vencidos')->default(0);
            $table->integer('gatewayPayment')->default(1);
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('financeiro2');
    }
};

