<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('financeiro_global', function (Blueprint $table) {
            $table->id();
            $table->integer('idc'); // ID do cliente
            $table->integer('idm'); // ID do usuário (carteira)
            $table->string('instancia', 60);
            $table->decimal('valorparcela', 10, 2);
            $table->integer('parcelas');
            $table->integer('gatewayPayment');
            $table->string('type', 20);
            $table->text('copiacola')->nullable();
            $table->text('codigobarra')->nullable();
            $table->text('imagemQrcode')->nullable();
            $table->string('id_payment', 255);
            $table->string('status_payment', 255);
            $table->date('entrada');
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('financeiro_global');
    }
};

