<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('mensagens', function (Blueprint $table) {
            $table->id();
            $table->string('idu', 9)->nullable(); // ID do usuário (carteira) - renomeado de idm para idu
            $table->text('msg')->nullable(); // Mensagem - renomeado de mensagem para msg
            $table->string('tipo', 2)->nullable(); // Tipo de mensagem (1-7)
            $table->string('status', 2)->default('1')->comment('1=ativo, 0=inativo');
            $table->string('hora', 5)->default('09:00')->comment('Horário de envio HH:MM');
            $table->string('ativo', 2)->default('1')->comment('1=ativo, 0=inativo');
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('mensagens');
    }
};
