<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('planos', function (Blueprint $table) {
            $table->unsignedInteger('id')->primary(); // int(6) UNSIGNED como no legado
            $table->string('nome', 255);
            $table->decimal('valor', 10, 2);
            $table->integer('cadastros_lim')->nullable()->comment('Limite de cadastros permitido neste plano');
            // Não usar timestamps no legado, mas manteremos para compatibilidade Laravel
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('planos');
    }
};
