<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('_pdv_caixa', function (Blueprint $table) {
            $table->id();
            $table->integer('idm')->comment('ID do usuário master');
            $table->dateTime('abertura');
            $table->dateTime('fechamento')->nullable();
            $table->decimal('saldo_inicial', 10, 2);
            $table->decimal('saldo_final', 10, 2)->nullable();
            $table->string('atendente_nome', 255)->nullable();
            $table->enum('status', ['aberto', 'fechado'])->default('aberto');
            $table->timestamps();

            $table->index('idm');
            $table->index('status');
            $table->index('abertura');
            
            // Foreign key para carteira (singular, como no legado)
            $table->foreign('idm')->references('Id')->on('carteira')->onDelete('cascade');
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('_pdv_caixa');
    }
};

