<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('_pdv_formas_pagamento', function (Blueprint $table) {
            $table->id();
            $table->integer('idm')->comment('ID do usuário master');
            $table->string('nome', 50);
            $table->timestamps();

            $table->index('idm');
            
            $table->foreign('idm')->references('Id')->on('carteira')->onDelete('cascade');
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('_pdv_formas_pagamento');
    }
};

