<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('_pdv_produtos', function (Blueprint $table) {
            $table->id();
            $table->integer('idm')->comment('ID do usuário master');
            $table->string('nome', 255);
            $table->text('descricao')->nullable();
            $table->decimal('preco_venda', 10, 2);
            $table->decimal('preco_custo', 10, 2)->default(0);
            $table->decimal('margem_lucro', 10, 2)->default(0);
            $table->integer('estoque')->default(0);
            $table->integer('estoque_minimo')->default(0);
            $table->boolean('alerta_estoque')->default(true);
            $table->string('codigo_barras', 50)->nullable();
            $table->string('unidade', 10)->default('un');
            $table->string('fabricante', 255)->nullable();
            $table->decimal('peso', 10, 2)->default(0);
            $table->string('ncm', 20)->nullable();
            $table->string('cfop', 10)->nullable();
            $table->unsignedBigInteger('fornecedor_id')->nullable();
            $table->unsignedBigInteger('categoria_id')->nullable();
            $table->string('imagem', 255)->nullable();
            $table->timestamps();

            $table->index('idm');
            $table->index('codigo_barras');
            $table->index('estoque');
            
            // Foreign keys para carteiras (não users)
            $table->foreign('idm')->references('Id')->on('carteira')->onDelete('cascade');
            $table->foreign('fornecedor_id')->references('id')->on('fornecedores')->onDelete('set null');
            $table->foreign('categoria_id')->references('id')->on('categoria')->onDelete('set null');
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('_pdv_produtos');
    }
};
