<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('funcionarios', function (Blueprint $table) {
            $table->id();
            $table->integer('id_saas')->comment('ID do usuário SaaS/master');
            $table->string('nome', 255);
            $table->string('celular', 15)->nullable();
            $table->string('login', 50);
            $table->string('senha', 255);
            $table->enum('roles', ['funcionario'])->default('funcionario');
            $table->decimal('porcentagem_vendas', 5, 2)->default(0)->comment('Porcentagem de comissão sobre vendas');
            $table->text('funcoes')->nullable()->comment('Funções habilitadas separadas por vírgula');
            $table->boolean('status')->default(true);
            $table->timestamps();

            $table->index('id_saas');
            $table->index('login');
            
            // Foreign key para carteiras (não users)
            $table->foreign('id_saas')->references('Id')->on('carteira')->onDelete('cascade');
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('funcionarios');
    }
};
