<?php

namespace Database\Seeders;

use App\Models\Plano;
use Illuminate\Database\Seeder;
use Illuminate\Support\Facades\DB;

class PlanosSeeder extends Seeder
{
    /**
     * Run the database seeds.
     */
    public function run(): void
    {
        // Limpar planos existentes (opcional, comentado para não perder dados)
        // Plano::truncate();

        $planos = [
            [
                'id' => 1,
                'nome' => 'Mensal',
                'valor' => 29.90,
                'cadastros_lim' => 1000,
            ],
            [
                'id' => 2,
                'nome' => 'Trimestral',
                'valor' => 79.90,
                'cadastros_lim' => 5000,
            ],
            [
                'id' => 3,
                'nome' => 'Semestral',
                'valor' => 149.90,
                'cadastros_lim' => 10000,
            ],
            [
                'id' => 4,
                'nome' => 'Anual',
                'valor' => 249.90,
                'cadastros_lim' => 50000,
            ],
            [
                'id' => 14,
                'nome' => 'Plano Padrão',
                'valor' => 50.00,
                'cadastros_lim' => 10000000, // Como no legado
            ],
        ];

        foreach ($planos as $plano) {
            // Usar updateOrCreate com id específico
            DB::table('planos')->updateOrInsert(
                ['id' => $plano['id']],
                [
                    'nome' => $plano['nome'],
                    'valor' => $plano['valor'],
                    'cadastros_lim' => $plano['cadastros_lim'],
                    'created_at' => now(),
                    'updated_at' => now(),
                ]
            );
        }

        $this->command->info('✅ Planos criados/atualizados com sucesso!');
        $this->command->info('   Total de planos: ' . count($planos));
    }
}
