$(document).ready(function () {
  // Carregar as cores salvas do banco de dados ao carregar a página
  loadSavedColors();

  // Detectar alterações nas cores e enviar para o servidor
  $('#colorForm input').on('input', function () {
      saveColors();
  });

  // Adicionar evento de clique no botão para salvar manualmente as cores
  $('#saveButton').on('click', function () {
      saveColors();
  });

  // Função para carregar as cores salvas do banco de dados
  function loadSavedColors() {
    $.ajax({
        type: 'GET',
        url: 'carregar_cores', // Substitua pela URL correta do seu script PHP
        success: function (response) {
            try {
                // Parse do JSON retornado (supondo que o retorno seja um JSON)
                var colors = JSON.parse(response);

                // Definir os valores iniciais nos campos de cor
                $('#sidebar_color').val(colors.sidebar_color);
                $('#topbar_color').val(colors.topbar_color);
            } catch (error) {
               // console.error(error);
            }
        },
        error: function (error) {
            //console.error(error);
        }
    });
}
  // Função para validar e formatar a cor
  function validateAndFormatColor(color) {
      // Implemente a lógica de validação e formatação conforme necessário
      // Certifique-se de que color esteja no formato "#rrggbb"
      return color;
  }

  // Função para enviar as cores para o servidor
  function saveColors() {
      var sidebarColor = validateAndFormatColor($('#sidebar_color').val());
      var topbarColor = validateAndFormatColor($('#topbar_color').val());

      // Verificar se as cores não estão vazias e têm o formato correto
      if (sidebarColor === '' || topbarColor === '') {
          //console.log('Por favor, selecione ambas as cores.');
          return;
      }

      // Use AJAX para enviar as cores para o script PHP de salvamento
      $.ajax({
          type: 'POST',
          url: 'salva_cores',
          data: {
              sidebar_color: sidebarColor,
              topbar_color: topbarColor
          },
          success: function (response) {
              //console.log(response);
          },
          error: function (error) {
              //console.error(error);
          }
      });
  }
});
