<?php
/**
 * This file prevents Apache from serving the directory directly
 * and forwards all requests to Laravel router
 */

// Get the current request URI
$requestUri = $_SERVER['REQUEST_URI'] ?? '/master';

// Extract the path after /master
$path = '/master';
if (preg_match('#^/public/master(.*)$#', $requestUri, $matches)) {
    $path = '/master' . $matches[1];
} elseif (preg_match('#^/master(.*)$#', $requestUri, $matches)) {
    $path = '/master' . $matches[1];
}

// If accessing directory root, ensure trailing slash
if ($path === '/master') {
    $path = '/master/';
}

// Set the REQUEST_URI to the correct path for Laravel
$_SERVER['REQUEST_URI'] = $path;
$_SERVER['SCRIPT_NAME'] = '/public/index.php';

// Change to the public directory and include Laravel's index.php
chdir(__DIR__ . '/..');
require __DIR__ . '/../index.php';

