<!DOCTYPE html>
<html lang="pt-BR">
<head>
    <meta charset="utf-8">
    <meta name="viewport" content="width=device-width, initial-scale=1, shrink-to-fit=no">
    <title>{{ $nomesistema ?? 'Gestor PRO' }} - Criar Conta</title>
    
    <link rel="icon" href="{{ $favicon }}" type="image/png">
    <link href="{{ asset('lib/font-awesome/css/font-awesome.css') }}" rel="stylesheet">
    <link href="{{ asset('lib/Ionicons/css/ionicons.css') }}" rel="stylesheet">
    <link rel="stylesheet" href="{{ asset('styles/dark-mode.css') }}">
    <link rel="stylesheet" href="{{ asset('css/slim.css') }}">
    
    <style>
        body {
            color: #000;
            overflow-x: hidden;
            height: 100%;
            background: linear-gradient(45deg, #D96D00 50%, #EEEEEE 50%);
            background-repeat: no-repeat;
        }

        .signin-box {
            background-color: white;
        }

        .card0 {
            box-shadow: 0px 4px 8px 0px #757575;
            border-radius: 10px;
        }

        input {
            padding: 10px 12px;
            border: 1px solid lightgrey;
            border-radius: 4px;
            margin-bottom: 25px;
            margin-top: 2px;
            width: 100%;
            box-sizing: border-box;
            color: #2C3E50;
            font-size: 14px;
            background-color: #ECEFF1;
        }

        input:focus {
            box-shadow: none !important;
            border: 1px solid #304FFE;
            outline-width: 0;
        }

        .btn-blue {
            background-color: #304FFE;
            width: 100%;
            color: #fff;
            border-radius: 6px;
        }

        .btn-blue:hover {
            background-color: #0D47A1;
            cursor: pointer;
        }
    </style>
</head>

<body>
    <div class="signin-wrapper">
        <div class="signin-box" align="center">
            <h3>{{ $nomesistema }} - Criar Conta</h3>
            <hr />

            <form method="POST" action="{{ route('register') }}">
                @csrf
                
                <div class="form-group">
                    <input type="text" class="form-control" name="nome" placeholder="Nome Completo" value="{{ old('nome') }}" required>
                    @error('nome')
                        <small style="color: red;">{{ $message }}</small>
                    @enderror
                </div>

                <div class="form-group">
                    <input type="email" class="form-control" name="login" placeholder="E-mail" value="{{ old('login') }}" required>
                    @error('login')
                        <small style="color: red;">{{ $message }}</small>
                    @enderror
                </div>

                <div class="form-group">
                    <input type="text" class="form-control" name="celular" placeholder="Celular" value="{{ old('celular') }}" required>
                    @error('celular')
                        <small style="color: red;">{{ $message }}</small>
                    @enderror
                </div>

                <div class="form-group">
                    <input type="password" class="form-control" name="senha" placeholder="Senha (mínimo 6 caracteres)" required>
                    @error('senha')
                        <small style="color: red;">{{ $message }}</small>
                    @enderror
                </div>

                <div class="form-group">
                    <input type="password" class="form-control" name="senha_confirmation" placeholder="Confirmar Senha" required>
                </div>

                @if($errors->any())
                <div class="form-group" style="color:#FF0000">
                    <i class="fa fa-certificate"></i> Verifique os campos acima.
                </div>
                @endif

                <button type="submit" class="btn btn-dark btn-block">Criar Conta</button>
            </form>

            <a href="{{ route('login') }}" class="btn btn-info btn-block mg-t-10">Voltar ao Login</a>
        </div>
    </div>
</body>
</html>

