@extends('layouts.app')

@section('title', 'Categorias')

@section('content')
<div class="dashboard-main-body">
  @if(session('success'))
    <span data-categoria-sucesso="true"></span>
  @endif

  <div class="d-flex flex-wrap align-items-center justify-content-between gap-3 mb-24">
    <div>
      <span class="text-secondary-light text-sm fw-medium d-block">Cadastros</span>
      <h6 class="fw-semibold mb-0 text-primary-light">Categorias de clientes e produtos</h6>
    </div>
    <ul class="d-flex align-items-center gap-2 mb-0">
      <li class="fw-medium text-secondary-light">
        <a href="{{ route('dashboard') }}" class="d-flex align-items-center gap-1 hover-text-primary">
          <iconify-icon icon="solar:home-smile-angle-outline" class="text-lg"></iconify-icon>
          Dashboard
        </a>
      </li>
      <li class="text-secondary-light">/</li>
      <li class="fw-medium text-secondary-light">Categorias</li>
    </ul>
  </div>

  <div class="row gy-4 mb-24">
    <div class="col-xxl-4 col-md-4">
      <div class="card bg-base border border-neutral-200 radius-16 shadow-sm h-100">
        <div class="card-body p-24 d-flex align-items-center gap-16">
          <span class="w-48-px h-48-px radius-12 d-flex justify-content-center align-items-center bg-primary-100 text-primary-600">
            <iconify-icon icon="solar:layers-outline" class="text-xl"></iconify-icon>
          </span>
          <div>
            <span class="text-secondary-light text-xs fw-medium d-block mb-4">Total de categorias</span>
            <h5 class="fw-semibold text-primary-light mb-0">{{ $totalCategorias }}</h5>
          </div>
        </div>
      </div>
    </div>
    <div class="col-xxl-4 col-md-4">
      <div class="card bg-base border border-neutral-200 radius-16 shadow-sm h-100">
        <div class="card-body p-24 d-flex align-items-center gap-16">
          <span class="w-48-px h-48-px radius-12 d-flex justify-content-center align-items-center bg-info-100 text-info-600">
            <iconify-icon icon="solar:box-outline" class="text-xl"></iconify-icon>
          </span>
          <div>
            <span class="text-secondary-light text-xs fw-medium d-block mb-4">Categorias de produtos</span>
            <h5 class="fw-semibold text-primary-light mb-0">{{ $categoriasProdutos->count() }}</h5>
          </div>
        </div>
      </div>
    </div>
    <div class="col-xxl-4 col-md-4">
      <div class="card bg-base border border-neutral-200 radius-16 shadow-sm h-100">
        <div class="card-body p-24 d-flex align-items-center gap-16">
          <span class="w-48-px h-48-px radius-12 d-flex justify-content-center align-items-center bg-lilac-100 text-lilac-600">
            <iconify-icon icon="solar:user-rounded-outline" class="text-xl"></iconify-icon>
          </span>
          <div>
            <span class="text-secondary-light text-xs fw-medium d-block mb-4">Categorias de clientes</span>
            <h5 class="fw-semibold text-primary-light mb-0">{{ $categoriasClientes->count() }}</h5>
          </div>
        </div>
      </div>
    </div>
  </div>

  <div class="card bg-base border border-neutral-200 radius-16 shadow-sm">
    <div class="card-header border-0 pb-0">
      <div class="d-flex flex-column flex-lg-row align-items-lg-center justify-content-between gap-3">
        <div>
          <h5 class="fw-semibold text-primary-light mb-4">Gerencie suas categorias</h5>
          <p class="text-secondary-light text-sm mb-0">Busque, filtre e mantenha a organização das categorias do sistema.</p>
        </div>
        <button type="button" class="btn btn-primary-600 radius-12 px-20 py-11 d-flex align-items-center gap-2" onclick="window.location.href='{{ route('categorias.create') }}'">
          <iconify-icon icon="solar:add-circle-outline" class="text-xl"></iconify-icon>
          Nova categoria
        </button>
      </div>
    </div>
    <div class="card-body pt-16">
      <div class="row g-3 align-items-end mb-24">
        <div class="col-lg-6">
          <label class="form-label fw-semibold text-primary-light text-sm mb-8 d-flex align-items-center gap-2">
            <iconify-icon icon="solar:magnifer-outline" class="text-lg"></iconify-icon>
            Buscar
          </label>
          <div class="position-relative">
            <iconify-icon icon="solar:magnifer-outline" class="position-absolute top-50 start-16 translate-middle-y text-secondary-light text-lg"></iconify-icon>
            <input type="text" id="buscaCategoria" class="form-control radius-12 h-48-px ps-48" placeholder="Digite o nome da categoria">
          </div>
        </div>
        <div class="col-lg-6">
          <label class="form-label fw-semibold text-primary-light text-sm mb-8 d-flex align-items-center gap-2">
            <iconify-icon icon="solar:filter-outline" class="text-lg"></iconify-icon>
            Filtrar por tipo
          </label>
          <div class="d-flex gap-2 flex-wrap">
            <button type="button" class="btn btn-primary-600 text-neutral-900 radius-10 px-20 py-10 d-flex align-items-center gap-2 active" data-filtro="todos">
              <iconify-icon icon="solar:menu-dots-outline" class="text-lg"></iconify-icon>
              Todas
              <span class="badge bg-neutral-100 text-neutral-600 text-xs fw-semibold px-8 py-4">{{ $totalCategorias }}</span>
            </button>
            <button type="button" class="btn btn-outline-primary-600 radius-10 px-20 py-10 d-flex align-items-center gap-2 text-secondary-light" data-filtro="produto">
              <iconify-icon icon="solar:box-outline" class="text-lg"></iconify-icon>
              Produtos
              <span class="badge bg-neutral-100 text-neutral-600 text-xs fw-semibold px-8 py-4">{{ $categoriasProdutos->count() }}</span>
            </button>
            <button type="button" class="btn btn-outline-primary-600 radius-10 px-20 py-10 d-flex align-items-center gap-2 text-secondary-light" data-filtro="cliente">
              <iconify-icon icon="solar:user-rounded-outline" class="text-lg"></iconify-icon>
              Clientes
              <span class="badge bg-neutral-100 text-neutral-600 text-xs fw-semibold px-8 py-4">{{ $categoriasClientes->count() }}</span>
            </button>
          </div>
        </div>
      </div>

      <div class="d-flex justify-content-between align-items-center mb-16">
        <span class="text-secondary-light text-sm" id="resultadoContagem">
          @if($totalCategorias === 0)
            Nenhuma categoria cadastrada
          @else
            {{ $totalCategorias }} categoria{{ $totalCategorias > 1 ? 's cadastradas' : ' cadastrada' }}
          @endif
        </span>
      </div>

      <div class="row g-3" id="gridCategorias">
        @if($totalCategorias > 0)
          @foreach($categorias as $categoria)
            @php
              $tipo = $categoria->tipo ?? null;
              $tipoNormalizado = ($tipo === null || $tipo === 'produto') ? 'produto' : 'cliente';
              $nome = htmlspecialchars($categoria->nome);
              $icone = $tipoNormalizado === 'cliente' ? 'solar:user-rounded-outline' : 'solar:box-outline';
              $badgeClass = $tipoNormalizado === 'cliente' ? 'bg-lilac-100 text-lilac-600' : 'bg-info-100 text-info-600';
              $tipoLabel = $tipoNormalizado === 'cliente' ? 'Cliente' : 'Produto';
            @endphp
            <div class="col-xxl-3 col-lg-4 col-md-6 categoria-card" data-nome="{{ strtolower($nome) }}" data-tipo="{{ $tipoNormalizado }}">
              <div class="card bg-base border border-neutral-200 radius-16 shadow-xxs h-100">
                <div class="card-body p-20 d-flex flex-column gap-16">
                  <div class="d-flex justify-content-between align-items-start">
                    <div class="d-flex align-items-center gap-3">
                      <span class="w-48-px h-48-px radius-12 d-flex justify-content-center align-items-center bg-neutral-100 text-primary-600">
                        <iconify-icon icon="{{ $icone }}" class="text-lg"></iconify-icon>
                      </span>
                      <div>
                        <h6 class="fw-semibold text-sm text-primary-light mb-4">{{ $nome }}</h6>
                        <span class="badge {{ $badgeClass }} text-xs fw-semibold px-10 py-4 radius-pill">{{ $tipoLabel }}</span>
                      </div>
                    </div>
                    <div class="dropdown">
                      <button class="btn btn-sm btn-ghost-neutral radius-10 px-10 py-6 d-flex align-items-center gap-1" type="button" data-bs-toggle="dropdown">
                        <iconify-icon icon="solar:menu-dots-outline" class="text-lg text-secondary-light"></iconify-icon>
                      </button>
                      <ul class="dropdown-menu dropdown-menu-end radius-16 border-neutral-200 shadow-sm">
                        <li>
                          <a href="{{ route('categorias.edit', $categoria->id) }}" class="dropdown-item d-flex align-items-center gap-2 text-secondary-light">
                            <iconify-icon icon="solar:pen-outline" class="text-md"></iconify-icon>
                            Editar categoria
                          </a>
                        </li>
                        <li>
                          <button type="button"
                                  class="dropdown-item text-danger d-flex align-items-center gap-2 btn-excluir-categoria"
                                  data-id="{{ $categoria->id }}"
                                  data-nome="{{ $nome }}">
                            <iconify-icon icon="solar:trash-bin-minimalistic-outline" class="text-md"></iconify-icon>
                            Excluir
                          </button>
                        </li>
                      </ul>
                    </div>
                  </div>
                  <div class="d-flex justify-content-between align-items-center bg-neutral-100 radius-12 px-12 py-10">
                    <span class="text-secondary-light text-xs">ID interno</span>
                    <span class="text-primary-light fw-semibold text-sm">#{{ $categoria->id }}</span>
                  </div>
                </div>
              </div>
            </div>
          @endforeach
        @endif
      </div>

      <div id="estadoVazioCategorias" class="card bg-base border border-neutral-200 radius-16 shadow-sm mt-16 {{ $totalCategorias > 0 ? 'd-none' : '' }}">
        <div class="card-body p-32 text-center">
          <iconify-icon icon="solar:inbox-outline" class="text-6xl text-secondary-light mb-16"></iconify-icon>
          <p class="text-secondary-light mb-16">Nenhuma categoria cadastrada no momento.</p>
          <button type="button" class="btn btn-primary-600 radius-12 px-24 py-12 d-inline-flex align-items-center gap-2" onclick="window.location.href='{{ route('categorias.create') }}'">
            <iconify-icon icon="solar:add-circle-outline" class="text-xl"></iconify-icon>
            Criar primeira categoria
          </button>
        </div>
      </div>
    </div>
  </div>
</div>
@endsection

@push('scripts')
<script src="//cdn.jsdelivr.net/npm/sweetalert2@11"></script>
<script>
document.addEventListener('DOMContentLoaded', function () {
  const searchInput = document.getElementById('buscaCategoria');
  const filterButtons = document.querySelectorAll('[data-filtro]');
  const cards = Array.from(document.querySelectorAll('.categoria-card'));
  const emptyState = document.getElementById('estadoVazioCategorias');
  const resultadoContagem = document.getElementById('resultadoContagem');

  const atualizarVisibilidade = () => {
    const termo = (searchInput?.value || '').trim().toLowerCase();
    const filtroAtivo = document.querySelector('[data-filtro].active')?.dataset.filtro || 'todos';
    let visiveis = 0;

    cards.forEach(card => {
      const nome = card.dataset.nome;
      const tipo = card.dataset.tipo;
      const correspondeBusca = termo.length === 0 || nome.includes(termo);
      const correspondeFiltro = filtroAtivo === 'todos' || filtroAtivo === tipo;

      const deveExibir = correspondeBusca && correspondeFiltro;
      card.style.display = deveExibir ? '' : 'none';
      if (deveExibir) visiveis++;
    });

    if (emptyState) {
      emptyState.classList.toggle('d-none', visiveis > 0);
    }

    if (resultadoContagem) {
      resultadoContagem.textContent = visiveis === 0
        ? 'Nenhuma categoria encontrada com os filtros atuais'
        : `${visiveis} categoria${visiveis > 1 ? 's' : ''} encontrada${visiveis > 1 ? 's' : ''}`;
    }
  };

  filterButtons.forEach(button => {
    button.addEventListener('click', () => {
      filterButtons.forEach(btn => {
        btn.classList.remove('active', 'btn-primary-600', 'text-neutral-900');
        if (!btn.classList.contains('btn-outline-primary-600')) {
          btn.classList.add('btn-outline-primary-600');
        }
      });

      button.classList.add('active', 'btn-primary-600', 'text-neutral-900');
      button.classList.remove('btn-outline-primary-600');
      atualizarVisibilidade();
    });
  });

  searchInput?.addEventListener('input', atualizarVisibilidade);
  atualizarVisibilidade();

  document.querySelectorAll('.btn-excluir-categoria').forEach(button => {
    button.addEventListener('click', () => {
      const id = button.getAttribute('data-id');
      const nome = button.getAttribute('data-nome');

      Swal.fire({
        title: 'Excluir categoria?',
        html: `<p class="text-secondary-light mb-0">Deseja remover <strong>${nome}</strong>?</p>`,
        icon: 'question',
        showCancelButton: true,
        confirmButtonText: 'Sim, excluir',
        cancelButtonText: 'Cancelar',
        customClass: {
          confirmButton: 'btn btn-danger-600 radius-8 px-20 py-10',
          cancelButton: 'btn btn-neutral-500 radius-8 px-20 py-10 me-8'
        },
        buttonsStyling: false
      }).then(result => {
        if (!result.isConfirmed) return;

        Swal.fire({
          title: 'Removendo...',
          text: 'Aguarde um instante',
          allowOutsideClick: false,
          allowEscapeKey: false,
          didOpen: () => Swal.showLoading()
        });

        // Criar form dinâmico para enviar DELETE
        const form = document.createElement('form');
        form.method = 'POST';
        form.action = '{{ route("categorias.destroy", ":id") }}'.replace(':id', id);
        
        const csrfToken = document.createElement('input');
        csrfToken.type = 'hidden';
        csrfToken.name = '_token';
        csrfToken.value = '{{ csrf_token() }}';
        form.appendChild(csrfToken);

        const methodInput = document.createElement('input');
        methodInput.type = 'hidden';
        methodInput.name = '_method';
        methodInput.value = 'DELETE';
        form.appendChild(methodInput);

        document.body.appendChild(form);
        form.submit();
      });
    });
  });

  const alertaSucesso = document.querySelector('[data-categoria-sucesso]');
  if (alertaSucesso) {
    Swal.fire({
      icon: 'success',
      title: 'Categoria salva!',
      timer: 1800,
      showConfirmButton: false
    });
    const url = new URL(window.location);
    url.searchParams.delete('sucesso');
    window.history.replaceState({}, document.title, url);
  }
});
</script>
@endpush
