@extends('layouts.app')

@section('title', 'Novo Cliente')

@section('content')
<div class="slim-mainpanel">
    <div class="container">
        <div class="section-wrapper mg-t-20">
            <label class="section-title">
                <i class="fa fa-user-plus" aria-hidden="true"></i> Novo Cliente
            </label>
            <hr>

            <form action="{{ route('clientes.store') }}" method="POST">
                @csrf
                
                <div class="row">
                    <div class="col-lg-6">
                        <div class="form-group">
                            <label for="nome">Nome Completo <span class="tx-danger">*</span></label>
                            <input type="text" class="form-control" id="nome" name="nome" value="{{ old('nome') }}" required>
                            @error('nome')
                                <span class="text-danger">{{ $message }}</span>
                            @enderror
                        </div>
                    </div>
                    
                    <div class="col-lg-6">
                        <div class="form-group">
                            <label for="celular">Celular <span class="tx-danger">*</span></label>
                            <input type="text" class="form-control" id="celular" name="celular" value="{{ old('celular') }}" required>
                            @error('celular')
                                <span class="text-danger">{{ $message }}</span>
                            @enderror
                        </div>
                    </div>
                </div>

                <div class="row">
                    <div class="col-lg-6">
                        <div class="form-group">
                            <label for="email">E-mail</label>
                            <input type="email" class="form-control" id="email" name="email" value="{{ old('email') }}">
                            @error('email')
                                <span class="text-danger">{{ $message }}</span>
                            @enderror
                        </div>
                    </div>
                    
                    <div class="col-lg-6">
                        <div class="form-group">
                            <label for="cpf_cnpj">CPF/CNPJ</label>
                            <input type="text" class="form-control" id="cpf_cnpj" name="cpf_cnpj" value="{{ old('cpf_cnpj') }}">
                            @error('cpf_cnpj')
                                <span class="text-danger">{{ $message }}</span>
                            @enderror
                        </div>
                    </div>
                </div>

                <div class="row">
                    <div class="col-lg-3">
                        <div class="form-group">
                            <label for="cep">CEP</label>
                            <input type="text" class="form-control" id="cep" name="cep" value="{{ old('cep') }}">
                        </div>
                    </div>
                    
                    <div class="col-lg-7">
                        <div class="form-group">
                            <label for="endereco">Endereço</label>
                            <input type="text" class="form-control" id="endereco" name="endereco" value="{{ old('endereco') }}">
                        </div>
                    </div>
                    
                    <div class="col-lg-2">
                        <div class="form-group">
                            <label for="numero">Número</label>
                            <input type="text" class="form-control" id="numero" name="numero" value="{{ old('numero') }}">
                        </div>
                    </div>
                </div>

                <div class="row">
                    <div class="col-lg-4">
                        <div class="form-group">
                            <label for="bairro">Bairro</label>
                            <input type="text" class="form-control" id="bairro" name="bairro" value="{{ old('bairro') }}">
                        </div>
                    </div>
                    
                    <div class="col-lg-6">
                        <div class="form-group">
                            <label for="cidade">Cidade</label>
                            <input type="text" class="form-control" id="cidade" name="cidade" value="{{ old('cidade') }}">
                        </div>
                    </div>
                    
                    <div class="col-lg-2">
                        <div class="form-group">
                            <label for="estado">UF</label>
                            <input type="text" class="form-control" id="estado" name="estado" value="{{ old('estado') }}" maxlength="2">
                        </div>
                    </div>
                </div>

                <div class="form-group">
                    <label for="observacoes">Observações</label>
                    <textarea class="form-control" id="observacoes" name="observacoes" rows="3">{{ old('observacoes') }}</textarea>
                </div>

                <div class="form-group mg-t-20">
                    <button type="submit" class="btn btn-success">
                        <i class="fa fa-check mg-r-5"></i> Salvar
                    </button>
                    <a href="{{ route('clientes.index') }}" class="btn btn-secondary">
                        <i class="fa fa-arrow-left mg-r-5"></i> Voltar
                    </a>
                </div>
            </form>
        </div>
    </div>
</div>
@endsection

