@extends('layouts.app')

@section('title', 'Clientes')

@push('styles')
<style>
.dt-paging .dt-paging-button.first,
.dt-paging .dt-paging-button.last {
  display: none !important;
}
.dt-paging .dt-paging-button {
  border-radius: 10px !important;
  overflow: hidden;
}
.dt-paging .dt-paging-button a {
  display: inline-flex;
  align-items: center;
  justify-content: center;
  width: 32px;
  height: 32px;
  border-radius: 8px;
  color: var(--secondary-light) !important;
  background: transparent;
  font-weight: 600;
}
.dt-paging .dt-paging-button.current a {
  background: var(--primary-500);
  color: var(--neutral-900) !important;
}
</style>
@endpush

@section('content')
<div class="dashboard-main-body">
  @if(session('sucesso'))
    <div class="alert alert-success-100 border border-success-200 radius-16 d-flex align-items-center gap-2" id="successAlert">
      <iconify-icon icon="solar:check-circle-outline" class="text-lg text-success-600"></iconify-icon>
      <span class="text-secondary-light">Operação realizada com sucesso.</span>
    </div>
  @endif

  <div class="d-flex flex-wrap align-items-center justify-content-between gap-3 mb-24">
    <div>
      <span class="text-secondary-light text-sm fw-medium d-block">Cadastros</span>
      <h6 class="fw-semibold mb-0 text-primary-light">Clientes cadastrados</h6>
    </div>
    <ul class="d-flex align-items-center gap-2 mb-0">
      <li class="fw-medium text-secondary-light">
        <a href="{{ route('dashboard') }}" class="d-flex align-items-center gap-1 hover-text-primary">
          <iconify-icon icon="solar:home-smile-angle-outline" class="text-lg"></iconify-icon>
          Dashboard
        </a>
      </li>
      <li class="text-secondary-light">/</li>
      <li class="fw-medium text-secondary-light">Clientes</li>
    </ul>
  </div>

  <div class="row gy-4 mb-24">
    <div class="col-xxl-3 col-md-6">
      <div class="card bg-base border border-neutral-200 radius-16 shadow-sm h-100">
        <div class="card-body p-20 d-flex align-items-center gap-16">
          <span class="w-48-px h-48-px radius-12 d-flex justify-content-center align-items-center bg-primary-100 text-primary-600">
            <iconify-icon icon="solar:users-group-rounded-outline" class="text-xl"></iconify-icon>
          </span>
          <div>
            <span class="text-secondary-light text-xs fw-medium d-block mb-4">Clientes ativos</span>
            <h5 class="fw-semibold text-primary-light mb-0">{{ $totalCadastrados }}</h5>
          </div>
        </div>
      </div>
    </div>
    <div class="col-xxl-3 col-md-6">
      <div class="card bg-base border border-neutral-200 radius-16 shadow-sm h-100">
        <div class="card-body p-20 d-flex align-items-center gap-16">
          <span class="w-48-px h-48-px radius-12 d-flex justify-content-center align-items-center bg-info-100 text-info-600">
            <iconify-icon icon="solar:chart-square-outline" class="text-xl"></iconify-icon>
          </span>
          <div>
            <span class="text-secondary-light text-xs fw-medium d-block mb-4">Limite disponível</span>
            <h5 class="fw-semibold text-primary-light mb-0">{{ $limiteDisponivel ?? 'Ilimitado' }}</h5>
          </div>
        </div>
      </div>
    </div>
    <div class="col-xxl-3 col-md-6">
      <div class="card bg-base border border-neutral-200 radius-16 shadow-sm h-100">
        <div class="card-body p-20 d-flex align-items-center gap-16">
          <span class="w-48-px h-48-px radius-12 d-flex justify-content-center align-items-center bg-success-100 text-success-600">
            <iconify-icon icon="solar:download-outline" class="text-xl"></iconify-icon>
          </span>
          <div>
            <span class="text-secondary-light text-xs fw-medium d-block mb-4">Importações recentes</span>
            <h5 class="fw-semibold text-primary-light mb-0">CSV / Excel</h5>
            <small class="text-secondary-light d-block mt-4">Indicador informativo</small>
          </div>
        </div>
      </div>
    </div>
    <div class="col-xxl-3 col-md-6">
      <div class="card bg-base border border-neutral-200 radius-16 shadow-sm h-100">
        <div class="card-body p-20 d-flex align-items-center gap-16">
          <span class="w-48-px h-48-px radius-12 d-flex justify-content-center align-items-center bg-warning-100 text-warning-600">
            <iconify-icon icon="solar:shield-star-outline" class="text-xl"></iconify-icon>
          </span>
          <div>
            <span class="text-secondary-light text-xs fw-medium d-block mb-4">Plano atual</span>
            <h5 class="fw-semibold text-primary-light mb-0">{{ $planoNome ?? 'Grátis' }}</h5>
            <small class="text-secondary-light d-block mt-4">{{ $limite ? "{$totalCadastrados} / {$limite} clientes" : 'Sem limite definido' }}</small>
          </div>
        </div>
      </div>
    </div>
  </div>

  <div class="card bg-base border border-neutral-200 radius-16 shadow-sm">
    <div class="card-header border-0 pb-0">
      <div class="d-flex flex-column flex-lg-row align-items-lg-center justify-content-between gap-3">
        <div class="d-flex gap-2 flex-wrap">
          <a href="#" class="btn btn-outline-neutral-400 radius-12 px-20 py-10 d-flex align-items-center gap-2">
            <iconify-icon icon="solar:document-add-outline" class="text-lg"></iconify-icon>
            Baixar modelo CSV
          </a>
          <button type="button" class="btn btn-outline-primary-600 radius-12 px-20 py-10 d-flex align-items-center gap-2" id="loadCsv">
            <iconify-icon icon="solar:download-outline" class="text-lg"></iconify-icon>
            Importar CSV
          </button>
          <input type="file" id="fileInput" accept=".csv" hidden>
          <button type="button" class="btn btn-outline-primary-600 radius-12 px-20 py-10 d-flex align-items-center gap-2" id="getClients">
            <iconify-icon icon="solar:upload-outline" class="text-lg"></iconify-icon>
            Exportar clientes
          </button>
          <button type="button" class="btn btn-outline-danger-600 radius-12 px-20 py-10 d-flex align-items-center gap-2" id="deleteAllClientsButton">
            <iconify-icon icon="solar:trash-bin-trash-outline" class="text-lg"></iconify-icon>
            Excluir todos
          </button>
        </div>
        <div class="d-flex gap-2 flex-wrap">
          @if($canCreateClient ?? true)
            <a href="{{ route('clientes.create') }}" class="btn btn-primary-600 radius-12 px-20 py-10 d-flex align-items-center gap-2">
              <iconify-icon icon="solar:add-circle-outline" class="text-xl"></iconify-icon>
              Novo cliente
            </a>
          @else
            <button type="button" class="btn btn-outline-neutral-400 radius-12 px-20 py-10 d-flex align-items-center gap-2" disabled>
              <iconify-icon icon="solar:lock-keyhole-minimalistic-outline" class="text-lg"></iconify-icon>
              Limite atingido
            </button>
          @endif
        </div>
      </div>
    </div>
    <div class="card-body pt-16">
      <div class="row g-3 align-items-end mb-16">
        <div class="col-lg-6">
          <label class="form-label fw-semibold text-primary-light text-sm mb-8 d-flex align-items-center gap-2">
            <iconify-icon icon="solar:magnifer-outline" class="text-lg"></iconify-icon>
            Buscar cliente
          </label>
          <input type="text" id="buscaCliente" class="form-control radius-12 h-48-px" placeholder="Nome, CPF, telefone...">
        </div>
        <div class="col-lg-3">
          <label class="form-label fw-semibold text-primary-light text-sm mb-8 d-flex align-items-center gap-2">
            <iconify-icon icon="solar:tag-outline" class="text-lg"></iconify-icon>
            Filtrar por categoria
          </label>
          <select id="filtroCategoria" class="form-select radius-12 h-48-px">
            <option value="">Todas</option>
            @foreach($categorias as $categoria)
              <option value="{{ $categoria->nome }}">{{ $categoria->nome }}</option>
            @endforeach
          </select>
        </div>
      </div>

      <div class="table-responsive">
        <table class="table basic-border-table align-middle mb-0" id="clientesTable">
          <thead>
            <tr>
              <th style="text-align: left;">Foto</th>
              <th style="text-align: left;">#</th>
              <th style="text-align: left;">Grupo/Categoria</th>
              <th style="text-align: left;">Nome</th>
              <th style="text-align: left;">CPF</th>
              <th style="text-align: left;">Celular</th>
              <th style="text-align: center;">Ações</th>
            </tr>
          </thead>
          <tbody>
            @foreach($clientes as $cliente)
            <tr>
              <td>
                @if($cliente->foto)
                  <img src="{{ asset($cliente->foto) }}" alt="{{ $cliente->nome }}" class="w-40-px h-40-px object-fit-cover rounded-circle">
                @else
                  <div class="w-40-px h-40-px bg-neutral-200 rounded-circle d-flex align-items-center justify-content-center">
                    <iconify-icon icon="solar:user-outline" class="text-lg text-secondary-light"></iconify-icon>
                  </div>
                @endif
              </td>
              <td>{{ $cliente->id }}</td>
              <td>{{ $cliente->categoria->nome ?? '-' }}</td>
              <td>{{ $cliente->nome }}</td>
              <td>{{ $cliente->cpf }}</td>
              <td>
                <a href="https://api.whatsapp.com/send?phone=55{{ preg_replace('/\D/', '', $cliente->celular) }}&text=Olá {{ $cliente->nome }}" target="_blank" class="btn btn-sm btn-success me-2">
                  <iconify-icon icon="logos:whatsapp-icon" class="text-sm"></iconify-icon>
                </a>
                {{ $cliente->celular }}
              </td>
              <td align="center">
                <div class="d-flex gap-2 justify-content-center">
                  <a href="{{ route('clientes.show', $cliente->id) }}" class="btn btn-outline-info-600 btn-sm radius-8 px-12 py-6" title="Ver">
                    <iconify-icon icon="solar:eye-outline" class="text-md"></iconify-icon>
                  </a>
                  <a href="{{ route('clientes.edit', $cliente->id) }}" class="btn btn-outline-warning-600 btn-sm radius-8 px-12 py-6" title="Editar">
                    <iconify-icon icon="solar:pen-outline" class="text-md"></iconify-icon>
                  </a>
                  <form action="{{ route('clientes.destroy', $cliente->id) }}" method="POST" style="display: inline;" class="form-delete-cliente" data-cliente-nome="{{ $cliente->nome }}">
                    @csrf
                    @method('DELETE')
                    <button type="submit" class="btn btn-outline-danger-600 btn-sm radius-8 px-12 py-6" title="Excluir">
                      <iconify-icon icon="solar:trash-bin-minimalistic-outline" class="text-md"></iconify-icon>
                    </button>
                  </form>
                </div>
              </td>
            </tr>
            @endforeach
          </tbody>
        </table>
      </div>
    </div>
  </div>
</div>
@endsection

@push('scripts')
<script src="https://cdnjs.cloudflare.com/ajax/libs/toastr.js/latest/toastr.min.js"></script>
<link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/toastr.js/latest/toastr.min.css">
<script src="//cdn.jsdelivr.net/npm/sweetalert2@11"></script>
<script>
document.addEventListener('DOMContentLoaded', function () {
  // Configuração do Toastr
  toastr.options = {
    "closeButton": true,
    "debug": false,
    "newestOnTop": false,
    "progressBar": true,
    "positionClass": "toast-top-right",
    "preventDuplicates": false,
    "onclick": null,
    "showDuration": "300",
    "hideDuration": "1000",
    "timeOut": "5000",
    "extendedTimeOut": "1000",
    "showEasing": "swing",
    "hideEasing": "linear",
    "showMethod": "fadeIn",
    "hideMethod": "fadeOut"
  };

  // Aguardar um pouco para garantir que o DOM está totalmente carregado
  setTimeout(function() {
    // Verificar se a tabela já foi inicializada e destruir antes de recriar
    if ($.fn.DataTable.isDataTable('#clientesTable')) {
      $('#clientesTable').DataTable().destroy();
    }

    // DataTable
    const filtroBusca = document.getElementById('buscaCliente');
    const filtroCategoria = document.getElementById('filtroCategoria');

    const tabela = $('#clientesTable').DataTable({
      dom: 'lrtip',
      responsive: true,
      order: [[3, 'asc']],
      pageLength: 10,
      language: {
        sEmptyTable: 'Nenhum registro encontrado',
        sInfo: 'Mostrando _START_ a _END_ de _TOTAL_ clientes',
        sInfoEmpty: 'Mostrando 0 a 0 de 0 clientes',
        sInfoFiltered: '(filtrado de _MAX_ no total)',
        sLengthMenu: 'Mostrar _MENU_ clientes',
        sLoadingRecords: 'Carregando...',
        sProcessing: 'Processando...',
        sSearch: 'Buscar:',
        sZeroRecords: 'Nenhum cliente encontrado',
        paginate: {
          first: '',
          previous: '‹',
          next: '›',
          last: ''
        }
      },
      columnDefs: [
        { orderable: false, targets: -1 } // Desabilitar ordenação na última coluna (Ações)
      ]
    });

    window.clientesDataTable = tabela;

    filtroBusca?.addEventListener('input', () => {
      tabela.search(filtroBusca.value || '').draw();
    });

    filtroCategoria?.addEventListener('change', () => {
      tabela.column(2).search(filtroCategoria.value || '').draw();
    });
  }, 100);

  // Formulário de exclusão
  document.addEventListener('submit', function(event) {
    const form = event.target;
    if (!(form instanceof HTMLFormElement) || !form.classList.contains('form-delete-cliente')) {
      return;
    }

    event.preventDefault();
    const nomeCliente = form.dataset.clienteNome || 'este cliente';

    Swal.fire({
      title: 'Excluir cliente?',
      html: `
        <div class="d-flex flex-column gap-12 text-start">
          <p class="mb-0 text-secondary-light">
            Esta ação removerá todas as faturas, vendas PDV e registros vinculados a <strong>${nomeCliente}</strong>.
          </p>
        </div>
      `,
      showCancelButton: true,
      confirmButtonText: 'Excluir',
      cancelButtonText: 'Cancelar',
      buttonsStyling: false,
      reverseButtons: true,
      customClass: {
        popup: 'card bg-base border border-neutral-200 radius-16 shadow-lg p-24',
        title: 'fw-semibold text-danger-600 mb-12',
        htmlContainer: 'text-secondary-light mb-16',
        actions: 'd-flex gap-3 justify-content-end',
        confirmButton: 'btn btn-danger-600 radius-12 px-24 py-10',
        cancelButton: 'btn btn-outline-neutral-500 radius-12 px-24 py-10 text-neutral-600'
      },
      focusConfirm: false
    }).then((result) => {
      if (result.isConfirmed) {
        form.submit();
      }
    });
  });

  // Sucesso
  @if(session('sucesso'))
    toastr.success('Operação realizada com sucesso!');
    setTimeout(function() {
      const alert = document.getElementById('successAlert');
      if (alert) {
        alert.style.transition = 'opacity 0.5s ease-out';
        alert.style.opacity = '0';
        setTimeout(function() {
          alert.remove();
        }, 500);
      }
    }, 3000);
  @endif
});
</script>
@endpush
