@extends('layouts.app')

@section('title', 'Contas a Receber')

@push('styles')
<style>
.text-truncate-cell {
    max-width: 150px;
    white-space: nowrap;
    overflow: hidden;
    text-overflow: ellipsis;
    cursor: pointer;
    position: relative;
}
.text-truncate-cell:hover {
    background-color: #f8f9fa;
    border-radius: 4px;
    padding: 2px 4px;
}
.text-truncate-cell.expanded {
    white-space: normal !important;
    word-wrap: break-word !important;
    max-width: 300px !important;
    background-color: #fff !important;
    border: 2px solid #007bff !important;
    border-radius: 6px !important;
    padding: 10px !important;
    box-shadow: 0 4px 15px rgba(0,0,0,0.2) !important;
    z-index: 1000 !important;
    position: relative !important;
}
.filtro-btn {
    transition: all 0.3s ease;
    border-radius: 8px;
    font-weight: 500;
}
.filtro-btn:hover {
    transform: translateY(-1px);
    box-shadow: 0 4px 8px rgba(0,0,0,0.1);
}
.filtro-btn.active {
    transform: translateY(-1px);
    box-shadow: 0 4px 8px rgba(0,0,0,0.15);
}
</style>
@endpush

@section('content')
<div class="dashboard-main-body">
  <div class="d-flex flex-wrap align-items-center justify-content-between gap-3 mb-24">
    <h6 class="fw-semibold mb-0">Contas a Receber</h6>
    <ul class="d-flex align-items-center gap-2">
      <li class="fw-medium">
        <a href="{{ route('dashboard') }}" class="d-flex align-items-center gap-1 hover-text-primary">
          <iconify-icon icon="solar:home-smile-angle-outline" class="icon text-lg"></iconify-icon>
          Dashboard
        </a>
      </li>
      <li>-</li>
      <li class="fw-medium">Contas a Receber</li>
    </ul>
  </div>

  <div class="card basic-data-table">
    <div class="row gy-4">
      <div class="col-xxl-6">
        <div class="card">
          <div class="card-body p-20">
            <div class="row g-3">
              <div class="col-md-12">
                <div class="row g-3">
                  <div class="col-sm-4 col-xs-4">
                    <div class="radius-8 h-100 text-center p-20 bg-purple-light">
                      <span class="w-44-px h-44-px radius-8 d-inline-flex justify-content-center align-items-center text-xl mb-12 bg-lilac-200 border border-lilac-400 text-lilac-600">
                        <i class="ri-coins-fill"></i>
                      </span>
                      <span class="text-neutral-700 d-block">Valores recebidos</span>
                      <h6 class="mb-0 mt-4">R$ {{ number_format($valoresRecebidos ?? 0, 2, ',', '.') }}</h6>
                    </div>
                  </div>
                  <div class="col-sm-4 col-xs-4">
                    <div class="radius-8 h-100 text-center p-20 bg-success-100">
                      <span class="w-44-px h-44-px radius-8 d-inline-flex justify-content-center align-items-center text-xl mb-12 bg-success-200 border border-success-400 text-success-600">
                        <i class="ri-coins-fill"></i>
                      </span>
                      <span class="text-neutral-700 d-block">Valores a receber</span>
                      <h6 class="mb-0 mt-4">R$ {{ number_format($valoresAReceber ?? 0, 2, ',', '.') }}</h6>
                    </div>
                  </div>
                  <div class="col-sm-4 col-xs-4">
                    <div class="radius-8 h-100 text-center p-20 bg-danger-100 cursor-pointer" onclick="window.location.href='{{ route('financeiro.contas-vencidas') }}'" style="cursor: pointer;">
                      <span class="w-44-px h-44-px radius-8 d-inline-flex justify-content-center align-items-center text-xl mb-12 bg-danger-200 border border-danger-400 text-danger-600">
                        <i class="ri-time-line"></i>
                      </span>
                      <span class="text-neutral-700 d-block text-xs">CONTAS VENCIDAS</span>
                      <h6 class="mb-0 mt-4">{{ $contasVencidas ?? 0 }}</h6>
                      <small class="text-danger-600">R$ {{ number_format($valorVencido ?? 0, 2, ',', '.') }}</small>
                    </div>
                  </div>
                </div>
              </div>
            </div>
          </div>
        </div>
      </div>
      <div class="col-xxl-6">
        <div class="card">
          <div class="card-body p-20">
            <div class="row g-3">
              <div class="col-md-12">
                <div class="row g-3">
                  <div class="col-sm-3 col-xs-3">
                    <div class="radius-8 h-100 text-center p-20 bg-neutral-100">
                      <span class="w-44-px h-44-px radius-8 d-inline-flex justify-content-center align-items-center text-xl mb-12 bg-neutral-200 border border-neutral-400 text-neutral-600">
                        <i class="ri-folder-user-line"></i>
                      </span>
                      <span class="text-neutral-700 d-block text-xs">CLIENTES CADASTRADOS</span>
                      <h6 class="mb-0 mt-4">{{ $cadcli ?? 0 }}</h6>
                    </div>
                  </div>
                  <div class="col-sm-3 col-xs-3">
                    <div class="radius-8 h-100 text-center p-20 bg-primary-100">
                      <span class="w-44-px h-44-px radius-8 d-inline-flex justify-content-center align-items-center text-xl mb-12 bg-primary-200 border border-primary-400 text-primary-600">
                        <i class="ri-wechat-pay-line"></i>
                      </span>
                      <span class="text-dark-3 d-block text-xs">COBRANÇAS <br>ATIVAS</span>
                      <h6 class="mb-0 mt-4 text-dark-3">{{ $empativos ?? 0 }}</h6>
                    </div>
                  </div>
                  <div class="col-sm-3 col-xs-3">
                    <div class="radius-8 h-100 text-center p-20 bg-danger-100">
                      <span class="w-44-px h-44-px radius-8 d-inline-flex justify-content-center align-items-center text-xl mb-12 bg-danger-200 border border-danger-400 text-danger-600">
                        <i class="ri-refund-2-line"></i>
                      </span>
                      <span class="text-neutral-700 d-block text-xs">MENSALIDADES EM ABERTO</span>
                      <h6 class="mb-0 mt-4">{{ $parcelasab ?? 0 }}</h6>
                    </div>
                  </div>
                  <div class="col-sm-3 col-xs-3">
                    <div class="radius-8 h-100 text-center p-20 bg-success-100">
                      <span class="w-44-px h-44-px radius-8 d-inline-flex justify-content-center align-items-center text-xl mb-12 bg-success-200 border border-success-400 text-success-600">
                        <i class="ri-refund-2-line"></i>
                      </span>
                      <span class="text-neutral-700 d-block text-xs">MENSALIDADES PAGAS</span>
                      <h6 class="mb-0 mt-4">{{ $parcelasap ?? 0 }}</h6>
                    </div>
                  </div>
                </div>
              </div>
            </div>
          </div>
        </div>
      </div>
    </div>

    <div class="card-header" style="display: flex; justify-content: space-between; align-items: center; flex-wrap: wrap; gap: 10px;">
      <div align="left" class="mg-b-10">
        <div class="d-flex flex-wrap gap-2">
          <a href="{{ route('financeiro.criar-conta-receber') }}" class="fw-semibold text-lilac-600 py-16 px-24 border radius-12 text-md d-flex align-items-center justify-content-center gap-12 line-height-1 bg-hover-lilac-50">
            <iconify-icon icon="tabler:plus" class="text-lilac-600 text-xl line-height-1"></iconify-icon>
            Cadastrar Nova
          </a>
        </div>

        <!-- Filtros de Gateway -->
        <div class="mt-3">
          <div class="btn-group flex-wrap" role="group">
            <button onclick="filtrarGateway('todos')" type="button" class="btn btn-outline-primary-600 filtro-btn active" id="btn-todos">
              Todos
            </button>
            <button onclick="filtrarGateway('1')" type="button" class="btn btn-outline-primary-600 filtro-btn" id="btn-mercadopago">
              Mercado Pago
            </button>
            <button onclick="filtrarGateway('2')" type="button" class="btn btn-outline-primary-600 filtro-btn" id="btn-semgateway">
              Sem Gateway
            </button>
            <button onclick="filtrarGateway('4')" type="button" class="btn btn-outline-primary-600 filtro-btn" id="btn-paghiper">
              PagHiper
            </button>
            <button onclick="filtrarGateway('5')" type="button" class="btn btn-outline-primary-600 filtro-btn" id="btn-asaas">
              Asaas
            </button>
          </div>
        </div>
      </div>

      <div align="right" class="mg-b-10 d-flex flex-wrap gap-1">
        <div class="dropdown">
          <button class="btn btn-outline-primary-600 not-active px-18 py-11 dropdown-toggle toggle-icon" type="button" data-bs-toggle="dropdown">
            <i class="icon ion-ios-calendar-outline tx-24"></i> Alterar Mês
          </button>
          <ul class="dropdown-menu">
            <li><a class="dropdown-item" href="?mes=">Mês Atual</a></li>
            @foreach($meses as $mesNum => $mesNome)
              <li><a class="dropdown-item" href="?mes={{ $mesNum }}">{{ $mesNome }}</a></li>
            @endforeach
          </ul>
        </div>
      </div>
    </div>

    <div class="card-body table-responsive">
      @if(session('success'))
        <div class="alert alert-solid alert-success" role="alert">
          <strong>Sucesso!!!</strong>
        </div>
      @endif

      <table class="table bordered-table mb-0 display responsive nowrap w-100" id="aReceberTable" data-page-length='10'>
        <thead>
          <tr align="center">
            <th>#</th>
            <th>Nome</th>
            <th class="d-none d-lg-table-cell">Categoria</th>
            <th>Celular</th>
            <th class="d-none d-lg-table-cell">Próximo Vencimento</th>
            <th class="d-none d-md-table-cell">Valor Parcela</th>
            <th class="d-none d-xl-table-cell">Valor Total</th>
            <th>Parcelas</th>
            <th>Gateway</th>
            <th>Status</th>
            <th>Ver</th>
          </tr>
        </thead>
        <tbody>
          @foreach($cobrancas as $cobranca)
            @php
              $cliente = $cobranca->cliente;
              $gatewayName = $tiposCobrancas[$cobranca->gatewayPayment ?? 2] ?? 'Não definido';
              
              // Buscar próximo vencimento
              $proximoVencimento = \App\Models\Financeiro2::where('chave', $cobranca->chave)
                ->where('status', '1')
                ->orderByRaw("STR_TO_DATE(datapagamento, '%d/%m/%Y') ASC")
                ->first();
              
              $dataProximoVencimento = $proximoVencimento ? $proximoVencimento->datapagamento : 'N/A';
              
              // Verificar se está atrasado
              $atrasado = false;
              $diasAtraso = 0;
              if ($proximoVencimento) {
                $data1 = \Carbon\Carbon::now();
                $data2 = \Carbon\Carbon::createFromFormat('d/m/Y', $proximoVencimento->datapagamento);
                if ($data2->lt($data1)) {
                  $atrasado = true;
                  $diasAtraso = $data1->diffInDays($data2);
                }
              }
            @endphp
            <tr>
              <td align="center">{{ $cobranca->id }}</td>
              <td align="center">
                <div class="text-truncate-cell" title="{{ $cliente->nome ?? 'N/A' }} - {{ $cliente->cpf ?? '' }}">
                  {{ $cliente->nome ?? 'N/A' }}<br />
                  {{ $cliente->cpf ?? '' }}
                </div>
              </td>
              <td align="center" class="d-none d-lg-table-cell">
                {{ $cliente->categoria->nome ?? '-' }}
              </td>
              <td align="center">{{ $cliente->celular ?? '-' }}</td>
              <td align="center" class="d-none d-lg-table-cell">
                {{ $dataProximoVencimento }}
              </td>
              <td align="center" class="d-none d-md-table-cell">
                <strong>R$ {{ number_format($cobranca->vparcela ?? 0, 2, ',', '.') }}</strong>
              </td>
              <td align="center" class="d-none d-xl-table-cell">
                <strong class="text-success">R$ {{ number_format(($cobranca->vparcela ?? 0) * ($cobranca->parcelas ?? 0), 2, ',', '.') }}</strong>
              </td>
              <td align="center">{{ $cobranca->parcelas ?? 0 }}</td>
              <td align="center">
                <span class="badge bg-info-100 text-info-600 text-xs fw-semibold px-10 py-4">{{ $gatewayName }}</span>
              </td>
              <td align="center">
                @if($atrasado)
                  <span class="badge bg-danger-100 text-danger-600 text-xs fw-semibold px-10 py-4">
                    <i class='fas fa-exclamation-triangle'></i>
                    {{ $diasAtraso == 1 ? '1 DIA ATRASO' : "$diasAtraso DIAS ATRASO" }}
                  </span>
                @else
                  <span class="badge bg-success-100 text-success-600 text-xs fw-semibold px-10 py-4">
                    <i class='fas fa-check-circle'></i> EM DIAS
                  </span>
                @endif
              </td>
              <td align="center">
                <a href="#" class="btn btn-outline-info-600 btn-sm radius-8 px-12 py-6" title="Ver detalhes">
                  <i class="icon fa fa-search-plus"></i>
                </a>
              </td>
            </tr>
          @endforeach
        </tbody>
      </table>
    </div>
  </div>
</div>
@endsection

@push('scripts')
<script src="https://cdnjs.cloudflare.com/ajax/libs/toastr.js/latest/toastr.min.js"></script>
<link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/toastr.js/latest/toastr.min.css">
<script>
var table;
$(document).ready(function () {
  // Aguardar um pouco para garantir que o DOM está totalmente carregado
  setTimeout(function() {
    // Verificar se a tabela já foi inicializada e destruir antes de recriar
    if ($.fn.DataTable.isDataTable('#aReceberTable')) {
      $('#aReceberTable').DataTable().destroy();
    }
    
    // Inicializar DataTable
    table = $('#aReceberTable').DataTable({
      responsive: true,
      order: [[0, 'asc']],
      pageLength: 10,
      language: {
        url: '//cdn.datatables.net/plug-ins/1.13.7/i18n/pt-BR.json'
      },
      columnDefs: [
        { orderable: false, targets: -1 } // Desabilitar ordenação na última coluna (Ações)
      ]
    });

  // Expandir/contrair texto
  $(document).on('click', '.text-truncate-cell', function(e) {
    e.preventDefault();
    e.stopPropagation();
    const $cell = $(this);
    if ($cell.hasClass('expanded')) {
      $cell.removeClass('expanded');
      return;
    }
    $('.text-truncate-cell').removeClass('expanded');
    $cell.addClass('expanded');
    setTimeout(() => $cell.removeClass('expanded'), 5000);
  });
  }, 100);
});

function filtrarGateway(gateway) {
  // Verificar se a tabela existe antes de usar
  if (!table || !$.fn.DataTable.isDataTable('#aReceberTable')) {
    return;
  }
  
  document.querySelectorAll('.btn-group .btn').forEach(btn => {
    btn.classList.remove('active');
  });
  document.getElementById('btn-' + (gateway === '1' ? 'mercadopago' :
    gateway === '2' ? 'semgateway' :
      gateway === '4' ? 'paghiper' :
        gateway === '5' ? 'asaas' : 'todos')).classList.add('active');

  if (gateway === 'todos') {
    table.column(8).search('').draw();
  } else {
    var gatewayName = gateway === '1' ? 'Mercado Pago' :
      gateway === '2' ? 'Sem Gateway' :
        gateway === '4' ? 'PagHiper' :
          gateway === '5' ? 'Asaas' : '';
    table.column(8).search(gatewayName).draw();
  }
}
</script>
@endpush
