@extends('layouts.app')

@section('title', 'Contas Vencidas')

@push('styles')
<style>
.text-truncate-cell {
    max-width: 150px;
    white-space: nowrap;
    overflow: hidden;
    text-overflow: ellipsis;
    cursor: pointer;
    position: relative;
}
.text-truncate-cell:hover {
    background-color: #f8f9fa;
    border-radius: 4px;
    padding: 2px 4px;
}
.text-truncate-cell.expanded {
    white-space: normal !important;
    word-wrap: break-word !important;
    max-width: 300px !important;
    background-color: #fff !important;
    border: 2px solid #dc3545 !important;
    border-radius: 6px !important;
    padding: 10px !important;
    box-shadow: 0 4px 15px rgba(0,0,0,0.2) !important;
    z-index: 1000 !important;
    position: relative !important;
}
.filtro-btn {
    transition: all 0.3s ease;
    border-radius: 8px;
    font-weight: 500;
}
.filtro-btn:hover {
    transform: translateY(-1px);
    box-shadow: 0 4px 8px rgba(0,0,0,0.1);
}
.filtro-btn.active {
    transform: translateY(-1px);
    box-shadow: 0 4px 8px rgba(0,0,0,0.15);
}
</style>
@endpush

@section('content')
<div class="dashboard-main-body">
  <div class="d-flex flex-wrap align-items-center justify-content-between gap-3 mb-24">
    <h6 class="fw-semibold mb-0">Contas Vencidas</h6>
    <ul class="d-flex align-items-center gap-2">
      <li class="fw-medium">
        <a href="{{ route('dashboard') }}" class="d-flex align-items-center gap-1 hover-text-primary">
          <iconify-icon icon="solar:home-smile-angle-outline" class="icon text-lg"></iconify-icon>
          Dashboard
        </a>
      </li>
      <li>-</li>
      <li class="fw-medium">
        <a href="{{ route('financeiro.contas-receber') }}" class="hover-text-primary">Contas a Receber</a>
      </li>
      <li>-</li>
      <li class="fw-medium">Contas Vencidas</li>
    </ul>
  </div>

  <div class="card basic-data-table">
    <div class="row gy-4">
      <div class="col-xxl-6">
        <div class="card">
          <div class="card-body p-20">
            <div class="row g-3">
              <div class="col-md-12">
                <div class="row g-3">
                  <div class="col-sm-6 col-xs-6">
                    <div class="radius-8 h-100 text-center p-20 bg-danger-100">
                      <span class="w-44-px h-44-px radius-8 d-inline-flex justify-content-center align-items-center text-xl mb-12 bg-danger-200 border border-danger-400 text-danger-600">
                        <i class="ri-time-line"></i>
                      </span>
                      <span class="text-neutral-700 d-block">CONTAS VENCIDAS</span>
                      <h6 class="mb-0 mt-4">{{ $contasVencidas ?? 0 }}</h6>
                      <small class="text-danger-600">R$ {{ number_format($valoresVencidos ?? 0, 2, ',', '.') }}</small>
                    </div>
                  </div>
                  <div class="col-sm-6 col-xs-6">
                    <div class="radius-8 h-100 text-center p-20 bg-warning-100">
                      <span class="w-44-px h-44-px radius-8 d-inline-flex justify-content-center align-items-center text-xl mb-12 bg-warning-200 border border-warning-400 text-warning-600">
                        <i class="ri-team-line"></i>
                      </span>
                      <span class="text-dark d-block fw-semibold">CLIENTES COM CONTAS VENCIDAS</span>
                      <h6 class="mb-0 mt-4 text-dark">{{ $clientesVencidos ?? 0 }}</h6>
                    </div>
                  </div>
                </div>
              </div>
            </div>
          </div>
        </div>
      </div>
    </div>

    <div class="card-header" style="display: flex; justify-content: space-between; align-items: center; flex-wrap: wrap; gap: 10px;">
      <div align="left" class="mg-b-10">
        <div class="d-flex flex-wrap gap-2">
          <a href="{{ route('financeiro.contas-receber') }}" class="fw-semibold text-lilac-600 py-16 px-24 border radius-12 text-md d-flex align-items-center justify-content-center gap-12 line-height-1 bg-hover-lilac-50">
            <iconify-icon icon="solar:arrow-left-outline" class="text-lilac-600 text-xl line-height-1"></iconify-icon>
            Voltar para Contas a Receber
          </a>
        </div>
      </div>
    </div>

    <div class="card-body table-responsive">
      <table class="table bordered-table mb-0 display responsive nowrap w-100" id="contasVencidasTable" data-page-length='10'>
        <thead>
          <tr align="center">
            <th>#</th>
            <th>Nome</th>
            <th class="d-none d-lg-table-cell">Categoria</th>
            <th>Celular</th>
            <th class="d-none d-lg-table-cell">Vencimento</th>
            <th class="d-none d-md-table-cell">Valor Parcela</th>
            <th class="d-none d-xl-table-cell">Valor Total</th>
            <th>Parcelas</th>
            <th>Gateway</th>
            <th>Dias Atraso</th>
            <th>Ver</th>
          </tr>
        </thead>
        <tbody>
          @foreach($cobrancasVencidas as $cobranca)
            @php
              $cliente = $cobranca->cliente;
              $gatewayName = $tiposCobrancas[$cobranca->gatewayPayment ?? 2] ?? 'Não definido';
              
              // Buscar parcela vencida
              $parcelaVencida = \App\Models\Financeiro2::where('chave', $cobranca->chave)
                ->where('status', '1')
                ->whereRaw("STR_TO_DATE(datapagamento, '%d/%m/%Y') < CURDATE()")
                ->orderByRaw("STR_TO_DATE(datapagamento, '%d/%m/%Y') ASC")
                ->first();
              
              $dataVencimento = $parcelaVencida ? $parcelaVencida->datapagamento : 'N/A';
              
              // Calcular dias em atraso
              $diasAtraso = 0;
              if ($parcelaVencida) {
                $data1 = \Carbon\Carbon::now();
                $data2 = \Carbon\Carbon::createFromFormat('d/m/Y', $parcelaVencida->datapagamento);
                $diasAtraso = $data1->diffInDays($data2);
              }
            @endphp
            @if($cliente)
              <tr>
                <td align="center">{{ $cobranca->id }}</td>
                <td align="center">
                  <div class="text-truncate-cell" title="{{ $cliente->nome }} - {{ $cliente->cpf ?? '' }}">
                    {{ $cliente->nome }}<br />
                    {{ $cliente->cpf ?? '' }}
                  </div>
                </td>
                <td align="center" class="d-none d-lg-table-cell">
                  {{ $cliente->categoria->nome ?? '-' }}
                </td>
                <td align="center">{{ $cliente->celular ?? '-' }}</td>
                <td align="center" class="d-none d-lg-table-cell">
                  {{ $dataVencimento }}
                </td>
                <td align="center" class="d-none d-md-table-cell">
                  <strong>R$ {{ number_format($cobranca->vparcela ?? 0, 2, ',', '.') }}</strong>
                </td>
                <td align="center" class="d-none d-xl-table-cell">
                  <strong class="text-success">R$ {{ number_format(($cobranca->vparcela ?? 0) * ($cobranca->parcelas ?? 0), 2, ',', '.') }}</strong>
                </td>
                <td align="center">{{ $cobranca->parcelas ?? 0 }}</td>
                <td align="center">
                  <span class="badge bg-info-100 text-info-600 text-xs fw-semibold px-10 py-4">{{ $gatewayName }}</span>
                </td>
                <td align="center">
                  <span class="badge bg-danger-100 text-danger-600 text-xs fw-semibold px-10 py-4">
                    <i class='fas fa-exclamation-triangle'></i>
                    {{ $diasAtraso == 1 ? '1 DIA' : "$diasAtraso DIAS" }}
                  </span>
                </td>
                <td align="center">
                  <a href="#" class="btn btn-outline-info-600 btn-sm radius-8 px-12 py-6" title="Ver detalhes">
                    <i class="icon fa fa-search-plus"></i>
                  </a>
                </td>
              </tr>
            @endif
          @endforeach
        </tbody>
      </table>
    </div>
  </div>
</div>
@endsection

@push('scripts')
<script src="https://cdnjs.cloudflare.com/ajax/libs/toastr.js/latest/toastr.min.js"></script>
<link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/toastr.js/latest/toastr.min.css">
<script>
$(document).ready(function () {
  // Aguardar um pouco para garantir que o DOM está totalmente carregado
  setTimeout(function() {
    // Verificar se a tabela já foi inicializada e destruir antes de recriar
    if ($.fn.DataTable.isDataTable('#contasVencidasTable')) {
      $('#contasVencidasTable').DataTable().destroy();
    }
    
    // Inicializar DataTable
    $('#contasVencidasTable').DataTable({
      responsive: true,
      order: [[0, 'asc']],
      pageLength: 10,
      language: {
        url: '//cdn.datatables.net/plug-ins/1.13.7/i18n/pt-BR.json'
      },
      columnDefs: [
        { orderable: false, targets: -1 } // Desabilitar ordenação na última coluna (Ações)
      ]
    });

  // Expandir/contrair texto
  $(document).on('click', '.text-truncate-cell', function(e) {
    e.preventDefault();
    e.stopPropagation();
    const $cell = $(this);
    if ($cell.hasClass('expanded')) {
      $cell.removeClass('expanded');
      return;
    }
    $('.text-truncate-cell').removeClass('expanded');
    $cell.addClass('expanded');
    setTimeout(() => $cell.removeClass('expanded'), 5000);
  });
  }, 100);
});
</script>
@endpush

