@extends('layouts.app')

@section('title', 'Nova Conta a Pagar')

@section('content')
<div class="slim-mainpanel">
    <div class="container">
        <div class="section-wrapper mg-t-20">
            <label class="section-title">
                <i class="fa fa-plus-circle" aria-hidden="true"></i> Nova Conta a Pagar
            </label>
            <hr>

            <form action="{{ route('financeiro.store-conta-pagar') }}" method="POST">
                @csrf
                
                <div class="row">
                    <div class="col-lg-12">
                        <div class="form-group">
                            <label for="descricao">Descrição <span class="tx-danger">*</span></label>
                            <input type="text" class="form-control" id="descricao" name="descricao" required>
                        </div>
                    </div>
                </div>

                <div class="row">
                    <div class="col-lg-4">
                        <div class="form-group">
                            <label for="valor">Valor <span class="tx-danger">*</span></label>
                            <input type="text" class="form-control" id="valor" name="valor" required>
                        </div>
                    </div>
                    
                    <div class="col-lg-4">
                        <div class="form-group">
                            <label for="datavencimento">Vencimento <span class="tx-danger">*</span></label>
                            <input type="date" class="form-control" id="datavencimento" name="datavencimento" required>
                        </div>
                    </div>
                    
                    <div class="col-lg-4">
                        <div class="form-group">
                            <label for="categoria">Categoria</label>
                            <select class="form-control select2" id="categoria" name="categoria">
                                <option value="">Selecione uma categoria</option>
                                @foreach($categorias as $categoria)
                                    <option value="{{ $categoria->id }}">{{ $categoria->nome }}</option>
                                @endforeach
                            </select>
                        </div>
                    </div>
                </div>

                <div class="form-group">
                    <label for="observacoes">Observações</label>
                    <textarea class="form-control" id="observacoes" name="observacoes" rows="3"></textarea>
                </div>

                <div class="form-group mg-t-20">
                    <button type="submit" class="btn btn-success">
                        <i class="fa fa-check mg-r-5"></i> Salvar
                    </button>
                    <a href="{{ route('financeiro.contas-pagar') }}" class="btn btn-secondary">
                        <i class="fa fa-arrow-left mg-r-5"></i> Voltar
                    </a>
                </div>
            </form>
        </div>
    </div>
</div>
@endsection

@push('scripts')
<script>
    $(document).ready(function() {
        $('.select2').select2();
    });
</script>
@endpush

