@extends('layouts.app')

@section('title', 'Nova Conta a Receber')

@section('content')
<div class="slim-mainpanel">
    <div class="container">
        <div class="section-wrapper mg-t-20">
            <label class="section-title">
                <i class="fa fa-plus-circle" aria-hidden="true"></i> Nova Conta a Receber
            </label>
            <hr>

            <form action="{{ route('financeiro.store-conta-receber') }}" method="POST">
                @csrf
                
                <div class="row">
                    <div class="col-lg-6">
                        <div class="form-group">
                            <label for="idc">Cliente <span class="tx-danger">*</span></label>
                            <select class="form-control select2" id="idc" name="idc" required>
                                <option value="">Selecione um cliente</option>
                                @foreach($clientes as $cliente)
                                    <option value="{{ $cliente->id }}">{{ $cliente->nome }}</option>
                                @endforeach
                            </select>
                        </div>
                    </div>
                    
                    <div class="col-lg-6">
                        <div class="form-group">
                            <label for="categoria">Categoria</label>
                            <select class="form-control select2" id="categoria" name="categoria">
                                <option value="">Selecione uma categoria</option>
                                @foreach($categorias as $categoria)
                                    <option value="{{ $categoria->id }}">{{ $categoria->nome }}</option>
                                @endforeach
                            </select>
                        </div>
                    </div>
                </div>

                <div class="row">
                    <div class="col-lg-12">
                        <div class="form-group">
                            <label for="descricao">Descrição <span class="tx-danger">*</span></label>
                            <input type="text" class="form-control" id="descricao" name="descricao" required>
                        </div>
                    </div>
                </div>

                <div class="row">
                    <div class="col-lg-3">
                        <div class="form-group">
                            <label for="valor">Valor Total <span class="tx-danger">*</span></label>
                            <input type="text" class="form-control money" id="valor" name="valor" required>
                        </div>
                    </div>
                    
                    <div class="col-lg-3">
                        <div class="form-group">
                            <label for="parcelas">Parcelas <span class="tx-danger">*</span></label>
                            <input type="number" class="form-control" id="parcelas" name="parcelas" value="1" min="1" required>
                        </div>
                    </div>
                    
                    <div class="col-lg-3">
                        <div class="form-group">
                            <label for="vencimento">Primeiro Vencimento <span class="tx-danger">*</span></label>
                            <input type="date" class="form-control" id="vencimento" name="vencimento" required>
                        </div>
                    </div>
                    
                    <div class="col-lg-3">
                        <div class="form-group">
                            <label for="forma_pagamento">Forma de Pagamento</label>
                            <select class="form-control" id="forma_pagamento" name="forma_pagamento">
                                <option value="dinheiro">Dinheiro</option>
                                <option value="pix">PIX</option>
                                <option value="cartao">Cartão</option>
                                <option value="boleto">Boleto</option>
                            </select>
                        </div>
                    </div>
                </div>

                <small class="text-muted">
                    <i class="fa fa-info-circle"></i> 
                    O valor será dividido automaticamente pelas parcelas. Exemplo: R$ 100,00 em 2x = R$ 50,00 cada.
                </small>

                <div class="form-group">
                    <label for="observacoes">Observações</label>
                    <textarea class="form-control" id="observacoes" name="observacoes" rows="3"></textarea>
                </div>

                <div class="form-group mg-t-20">
                    <button type="submit" class="btn btn-success">
                        <i class="fa fa-check mg-r-5"></i> Salvar Direto
                    </button>
                    <button type="button" class="btn btn-info" id="btnSimular">
                        <i class="fa fa-calculator mg-r-5"></i> Simular Parcelas
                    </button>
                    <a href="{{ route('financeiro.contas-receber') }}" class="btn btn-secondary">
                        <i class="fa fa-arrow-left mg-r-5"></i> Voltar
                    </a>
                </div>
            </form>
        </div>
    </div>
</div>
@endsection

@push('scripts')
<script>
$(document).ready(function() {
    // Botão Simular
    $('#btnSimular').on('click', function(e) {
        e.preventDefault();
        
        // Valida campos obrigatórios
        var cliente = $('#idc').val();
        var valor = $('#valor').val();
        var parcelas = $('#parcelas').val();
        var vencimento = $('#vencimento').val();
        
        if (!cliente || !valor || !parcelas || !vencimento) {
            alert('Preencha todos os campos obrigatórios antes de simular!');
            return;
        }
        
        // Cria formulário temporário para simular
        var form = $('<form>', {
            'method': 'POST',
            'action': '{{ route("financeiro.simular-parcelas") }}'
        });
        
        form.append($('<input>', {
            'type': 'hidden',
            'name': '_token',
            'value': '{{ csrf_token() }}'
        }));
        
        form.append($('<input>', {
            'type': 'hidden',
            'name': 'cliente',
            'value': cliente
        }));
        
        form.append($('<input>', {
            'type': 'hidden',
            'name': 'valor',
            'value': valor
        }));
        
        form.append($('<input>', {
            'type': 'hidden',
            'name': 'parcelas',
            'value': parcelas
        }));
        
        form.append($('<input>', {
            'type': 'hidden',
            'name': 'datap',
            'value': vencimento
        }));
        
        $('body').append(form);
        form.submit();
    });
});
</script>
@endpush

@push('scripts')
<script src="{{ asset('lib/jquery.maskedinput/js/jquery.maskedinput.js') }}"></script>
<script src="{{ asset('js/moeda.js') }}"></script>
<script>
    $(document).ready(function() {
        $('.select2').select2();
        
        // Máscara monetária
        $('.money').mask('#.##0,00', { reverse: true });
    });
</script>
@endpush

