@extends('layouts.app')

@section('title', 'Pagamentos Finalizados')

@section('content')
<div class="dashboard-main-body">
  <div class="d-flex flex-wrap align-items-center justify-content-between gap-3 mb-24">
    <h6 class="fw-semibold mb-0">Pagamentos Finalizados</h6>
    <ul class="d-flex align-items-center gap-2">
      <li class="fw-medium">
        <a href="{{ route('dashboard') }}" class="d-flex align-items-center gap-1 hover-text-primary">
          <iconify-icon icon="solar:home-smile-angle-outline" class="icon text-lg"></iconify-icon>
          Dashboard
        </a>
      </li>
      <li>-</li>
      <li class="fw-medium">Pagamentos Finalizados</li>
    </ul>
  </div>

  <div class="card basic-data-table">
    <div class="card-header">
      <h5 class="card-title mb-0">Pagamentos</h5>
    </div>
    <div class="card-body table-responsive">
      <table class="table bordered-table mb-0 w-100" id="cobrancasBody" data-page-length='10'>
        <thead>
          <tr>
            <th scope="col">ID</th>
            <th scope="col">Nome</th>
            <th scope="col">Data Cadastro</th>
            <th scope="col">Status</th>
            <th scope="col">Ação</th>
          </tr>
        </thead>
        <tbody>
          @foreach($cobrancasFinalizadas as $cobranca)
            @php
              $cliente = $cobranca->cliente;
            @endphp
            @if($cliente)
              <tr>
                <td>
                  <a href="javascript:void(0)" class="text-primary-600">#{{ $cobranca->id }}</a>
                </td>
                <td>
                  <div class="d-flex align-items-center">
                    <h6 class="text-md mb-0 fw-medium flex-grow-1">{{ $cliente->nome }}</h6>
                  </div>
                </td>
                <td>{{ $cobranca->entrada && $cobranca->entrada != 'n' ? $cobranca->entrada : \Carbon\Carbon::parse($cobranca->created_at)->format('d/m/Y') }}</td>
                <td>
                  <span class="bg-success-focus text-success-main px-24 py-4 rounded-pill fw-medium text-sm">Pago</span>
                </td>
                <td>
                  <button type="button" class="w-32-px h-32-px bg-primary-light text-primary-600 rounded-circle d-inline-flex align-items-center justify-content-center" data-bs-toggle="modal" data-bs-target="#clienteModal{{ $cobranca->id }}">
                    <iconify-icon icon="iconamoon:eye-light"></iconify-icon>
                  </button>
                </td>
              </tr>

              <!-- Modal -->
              <div class="modal fade" id="clienteModal{{ $cobranca->id }}" tabindex="-1" aria-labelledby="clienteModalLabel{{ $cobranca->id }}" aria-hidden="true">
                <div class="modal-dialog modal-lg">
                  <div class="modal-content">
                    <div class="modal-header">
                      <h5 class="modal-title" id="clienteModalLabel{{ $cobranca->id }}">Cliente</h5>
                      <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
                    </div>
                    <div class="modal-body">
                      <div class="row">
                        <div class="col-md-12 text-center">
                          <div class="form-group">
                            <h4><span style="color:#FF9966"></span> {{ $cliente->nome }}</h4>
                            @if($cobranca->status == 2)
                              <button class="btn btn-success btn-sm">QUITADO EM {{ \Carbon\Carbon::parse($cobranca->pagoem ?? $cobranca->updated_at)->format('d/m/Y H:i:s') }}</button>
                            @endif
                          </div>
                        </div>
                      </div>
                      <hr style="margin-top:-5px;">
                      <div class="row">
                        <div class="col-md-3">
                          <div class="form-group">
                            <label>Valor Total</label>
                            <input type="text" class="form-control" value="R$ {{ number_format(($cobranca->vparcela ?? 0) * ($cobranca->parcelas ?? 0), 2, ',', '.') }}" readonly>
                          </div>
                        </div>
                        <div class="col-md-3">
                          <div class="form-group">
                            <label>Forma de Pagamento</label>
                            @php
                              $formas = [
                                1 => 'Diário',
                                7 => 'Semanal',
                                15 => 'Quinzenal',
                                30 => 'Mensal'
                              ];
                              $forma = $formas[$cobranca->formapagamento ?? 30] ?? 'Mensal';
                            @endphp
                            <input type="text" name="valor" class="form-control" value="{{ $forma }}" readonly>
                          </div>
                        </div>
                        <div class="col-md-3">
                          <div class="form-group">
                            <label>Parcelas</label>
                            <input type="number" name="parcelas" class="form-control" value="{{ $cobranca->parcelas ?? 0 }}" readonly>
                          </div>
                        </div>
                        <div class="col-md-3">
                          <div class="form-group">
                            <label>Primeira Parcela</label>
                            <input type="text" class="form-control" value="{{ $cobranca->primeiraparcela ?? '-' }}" readonly>
                          </div>
                        </div>
                      </div>
                      <hr />
                      <div class="row">
                        @php
                          $parcelas = \App\Models\Financeiro2::where('chave', $cobranca->chave)
                            ->orderBy('id', 'asc')
                            ->get();
                        @endphp
                        @foreach($parcelas as $parcela)
                          <div class="col-md-6">
                            <div class="form-group">
                              <label>Valor da Parcela</label>
                              <input type="text" class="form-control" value="R$ {{ number_format($parcela->parcela, 2, ',', '.') }}" readonly>
                            </div>
                          </div>
                          <div class="col-md-3">
                            <div class="form-group">
                              <label>Vencimento Original</label>
                              <input type="text" class="form-control" value="{{ $parcela->datapagamento }}" readonly>
                            </div>
                          </div>
                          <div class="col-md-3">
                            <div class="form-group">
                              <label>Data de Pagamento</label>
                              <input type="text" class="form-control" value="{{ $parcela->pagoem ?? '-' }}" readonly>
                            </div>
                          </div>
                        @endforeach
                      </div>
                      <hr />
                    </div>
                  </div>
                </div>
              </div>
            @endif
          @endforeach
        </tbody>
      </table>
    </div>
  </div>
</div>
@endsection

@push('scripts')
<script>
$(document).ready(function() {
  // Aguardar um pouco para garantir que o DOM está totalmente carregado
  setTimeout(function() {
    // Verificar se a tabela já foi inicializada e destruir antes de recriar
    if ($.fn.DataTable.isDataTable('#cobrancasBody')) {
      $('#cobrancasBody').DataTable().destroy();
    }
    
    // Inicializar DataTable
    $('#cobrancasBody').DataTable({
      responsive: true,
      order: [[0, 'asc']],
      pageLength: 10,
      language: {
        url: '//cdn.datatables.net/plug-ins/1.13.7/i18n/pt-BR.json'
      },
      columnDefs: [
        { orderable: false, targets: -1 } // Desabilitar ordenação na última coluna (Ações)
      ]
    });
  }, 100);
});
</script>
@endpush
