@extends('layouts.app')

@section('title', 'Histórico de Transações')

@section('content')
<div class="dashboard-main-body">
    <div class="d-flex flex-wrap align-items-center justify-content-between gap-3 mb-24">
        <h6 class="fw-semibold mb-0">Transações</h6>
        <ul class="d-flex align-items-center gap-2">
            <li class="fw-medium">
                <a href="{{ route('dashboard') }}" class="d-flex align-items-center gap-1 hover-text-primary">
                    <iconify-icon icon="solar:home-smile-angle-outline" class="icon text-lg"></iconify-icon>
                    Dashboard
                </a>
            </li>
            <li>-</li>
            <li class="fw-medium">Transações</li>
        </ul>
    </div>

    <div class="card basic-data-table">
        <div class="card-header">
            <h5 class="card-title mb-0">Histórico</h5>
        </div>
        <div class="card-body table-responsive">
            <table class="table bordered-table mb-0 w-100" id="dataTable" data-page-length='10'>
                <thead>
                    <tr>
                        <th>#</th>
                        <th>Nome</th>
                        <th>Data da Parcela</th>
                        <th>Data do Pagamento</th>
                        <th>Valor</th>
                        <th>Parcelas Pagas</th>
                        <th>Status</th>
                    </tr>
                </thead>
                <tbody>
                    @if(isset($transacoes) && count($transacoes) > 0)
                        @foreach($transacoes as $transacao)
                        <tr>
                            <td>{{ $transacao->Id ?? $transacao->id ?? '-' }}</td>
                            <td>
                                <div class="d-flex align-items-center">
                                    <h6 class="text-md mb-0 fw-medium flex-grow-1">{{ $transacao->nome ?? '-' }}</h6>
                                </div>
                            </td>
                            <td>{{ $transacao->datapagamento ?? '-' }}</td>
                            <td>{{ $transacao->pagoem ?? '-' }}</td>
                            <td>R$ {{ number_format($transacao->parcela ?? 0, 2, ',', '.') }}</td>
                            <td>{{ $transacao->parcelas_pagas ?? 0 }} de {{ $transacao->parcelas ?? 0 }}</td>
                            <td>
                                @if(($transacao->status ?? '') == '2')
                                    <span class="bg-success-focus text-success-main px-24 py-4 rounded-pill fw-medium text-sm">Pago</span>
                                @else
                                    <span class="bg-danger-focus text-danger-main px-24 py-4 rounded-pill fw-medium text-sm">Pendente</span>
                                @endif
                            </td>
                        </tr>
                        @endforeach
                    @else
                        <tr>
                            <td colspan="7" class="text-center text-muted py-4">
                                Nenhuma transação encontrada.
                            </td>
                        </tr>
                    @endif
                </tbody>
            </table>
        </div>
    </div>
</div>
@endsection

@push('scripts')
<script>
    $(document).ready(function() {
        // Aguardar um pouco para garantir que o DOM está totalmente carregado
        setTimeout(function() {
            if ($.fn.DataTable.isDataTable('#dataTable')) {
                $('#dataTable').DataTable().destroy();
            }
            
            // Verificar se a tabela tem dados válidos (sem colspan)
            var table = $('#dataTable');
            var tbody = table.find('tbody');
            var rows = tbody.find('tr');
            var hasValidData = false;
            
            // Remover linha com colspan antes de inicializar DataTables
            rows.each(function() {
                var $row = $(this);
                var $td = $row.find('td[colspan]');
                if ($td.length > 0) {
                    $row.remove(); // Remove linha com colspan
                } else {
                    var tdCount = $row.find('td').length;
                    // Se a linha tem 7 colunas, tem dados válidos
                    if (tdCount === 7) {
                        hasValidData = true;
                    }
                }
            });
            
            // Só inicializar se houver dados válidos
            if (hasValidData) {
                $('#dataTable').DataTable({
                    responsive: true,
                    order: [[0, 'asc']],
                    pageLength: 10,
                    columnDefs: [
                        { responsivePriority: 1, targets: 0 },
                        { responsivePriority: 2, targets: -1 },
                        { orderable: false, targets: -1 } // Desabilitar ordenação na última coluna (Ações)
                    ],
                    language: {
                        url: '//cdn.datatables.net/plug-ins/1.10.24/i18n/Portuguese-Brasil.json'
                    }
                });
            }
        }, 100);
    });
</script>
@endpush

