@extends('layouts.app')

@section('title', 'Simulador de Parcelas')

@section('content')
<div class="slim-mainpanel">
    <div class="container">
        <div align="right" class="mg-b-10">
            <a href="{{ route('financeiro.criar-conta-receber') }}" class="btn btn-purple btn-sm">
                <i class="fa fa-arrow-left mg-r-5"></i> VOLTAR
            </a>
        </div>

        <div class="row">
            <div class="col-md-12">
                <div class="card card-info">
                    <div class="card-body">
                        <label class="section-title">
                            <i class="fa fa-calculator" aria-hidden="true"></i> Demonstrativo de Cobranças
                        </label>
                        <hr>

                        {{-- Informações do Cliente --}}
                        <div class="row">
                            <div class="col-md-12" align="center">
                                <div class="form-group">
                                    <h4>
                                        <span class="tx-primary">{{ $cliente->nome }}</span>
                                    </h4>
                                    <p class="tx-gray-600">
                                        <i class="fa fa-phone mg-r-5"></i> {{ $cliente->celular }}
                                        <i class="fa fa-envelope mg-l-10 mg-r-5"></i> {{ $cliente->email }}
                                    </p>
                                </div>
                            </div>
                        </div>

                        <hr>

                        {{-- Resumo --}}
                        <div class="row">
                            <div class="col-md-3">
                                <div class="form-group">
                                    <label>Valor Total</label>
                                    <input type="text" class="form-control" 
                                        value="R$ {{ number_format($valorTotal, 2, ',', '.') }}" disabled>
                                </div>
                            </div>

                            <div class="col-md-3">
                                <div class="form-group">
                                    <label>Forma de Pagamento</label>
                                    <input type="text" class="form-control" value="Mensal" disabled>
                                </div>
                            </div>

                            <div class="col-md-3">
                                <div class="form-group">
                                    <label>Quantidade de Mensalidades</label>
                                    <input type="number" class="form-control" value="{{ $parcelas }}" disabled>
                                </div>
                            </div>

                            <div class="col-md-3">
                                <div class="form-group">
                                    <label>Primeira Mensalidade</label>
                                    <input type="text" class="form-control" value="{{ $primeiraParcela }}" disabled>
                                </div>
                            </div>
                        </div>

                        <hr />

                        {{-- Lista de Parcelas --}}
                        <div class="row">
                            @foreach($simulacao as $parc)
                            <div class="col-md-6">
                                <div class="form-group">
                                    <label>Parcela {{ $parc['numero'] }} - Valor</label>
                                    <input type="text" class="form-control" 
                                        value="R$ {{ number_format($parc['valor'], 2, ',', '.') }}" disabled>
                                </div>
                            </div>
                            
                            <div class="col-md-6">
                                <div class="form-group">
                                    <label>Parcela {{ $parc['numero'] }} - Vencimento</label>
                                    <input type="text" class="form-control" 
                                        value="{{ $parc['vencimento'] }}" disabled>
                                </div>
                            </div>
                            @endforeach
                        </div>

                        <hr />

                        {{-- Formulário de Confirmação --}}
                        <form action="{{ route('financeiro.confirmar-simulacao') }}" method="POST">
                            @csrf
                            
                            <input type="hidden" name="idcliente" value="{{ $cliente->id }}">
                            <input type="hidden" name="formapagamento" value="{{ $formapagamento }}">
                            <input type="hidden" name="parcelas" value="{{ $parcelas }}">
                            <input type="hidden" name="dataparcela" value="{{ $primeiraParcela }}">
                            <input type="hidden" name="dataparcelax" value="{{ $primeiraParcelaOriginal }}">
                            <input type="hidden" name="idpedido" value="{{ $chave }}">
                            <input type="hidden" name="vparcela" value="{{ $valorParcela }}">

                            <div class="row">
                                <div class="col-md-6">
                                    <div class="form-group">
                                        <label>Tipo de Pagamento <span class="tx-danger">*</span></label>
                                        <select name="typePayment" class="form-control" required>
                                            <option value="">Selecione...</option>
                                            <option value="pix">PIX</option>
                                            <option value="boleto">BOLETO</option>
                                        </select>
                                    </div>
                                </div>

                                <div class="col-md-6">
                                    <div class="form-group">
                                        <label>&nbsp;</label>
                                        <div>
                                            <a href="{{ route('financeiro.criar-conta-receber') }}" class="btn btn-secondary">
                                                <i class="fa fa-arrow-left mg-r-5"></i> Voltar
                                            </a>
                                            <button type="submit" class="btn btn-success">
                                                <i class="fa fa-check mg-r-5"></i> Cadastrar
                                            </button>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </form>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>
@endsection

