@extends('layouts.app')

@section('content')
<div class="container-fluid">
    <div class="row">
        <div class="col-12">
            <div class="card">
                <div class="card-header d-flex justify-content-between align-items-center">
                    <h4>Editar Funcionário: {{ $funcionario->nome }}</h4>
                    <a href="{{ route('funcionarios.index') }}" class="btn btn-secondary">
                        <i class="fas fa-arrow-left"></i> Voltar
                    </a>
                </div>
                <div class="card-body">
                    @if($errors->any())
                        <div class="alert alert-danger">
                            <ul class="mb-0">
                                @foreach($errors->all() as $error)
                                    <li>{{ $error }}</li>
                                @endforeach
                            </ul>
                        </div>
                    @endif

                    <form action="{{ route('funcionarios.update', $funcionario->id) }}" method="POST">
                        @csrf
                        @method('PUT')

                        <div class="row">
                            <div class="col-md-4">
                                <div class="mb-3">
                                    <label for="nome" class="form-label">Nome *</label>
                                    <input type="text" class="form-control" id="nome" name="nome" value="{{ old('nome', $funcionario->nome) }}" required maxlength="255">
                                </div>
                            </div>

                            <div class="col-md-2">
                                <div class="mb-3">
                                    <label for="celular" class="form-label">WhatsApp</label>
                                    <input type="text" class="form-control" id="celular" name="celular" value="{{ old('celular', $funcionario->celular) }}" maxlength="15" placeholder="11999999999">
                                </div>
                            </div>

                            <div class="col-md-2">
                                <div class="mb-3">
                                    <label for="login" class="form-label">Login *</label>
                                    <input type="text" class="form-control" id="login" name="login" value="{{ old('login', $funcionario->login) }}" required maxlength="50">
                                </div>
                            </div>

                            <div class="col-md-2">
                                <div class="mb-3">
                                    <label for="senha" class="form-label">Nova Senha</label>
                                    <input type="password" class="form-control" id="senha" name="senha" minlength="6" maxlength="255">
                                    <small class="text-muted">Deixe em branco para manter a senha atual</small>
                                </div>
                            </div>

                            <div class="col-md-2">
                                <div class="mb-3">
                                    <label for="roles" class="form-label">Nível de Acesso *</label>
                                    <select class="form-select" id="roles" name="roles" required>
                                        <option value="funcionario" {{ old('roles', $funcionario->roles) == 'funcionario' ? 'selected' : '' }}>Funcionário</option>
                                    </select>
                                </div>
                            </div>
                        </div>

                        <div class="row">
                            <div class="col-md-3">
                                <div class="mb-3">
                                    <label for="porcentagem_vendas" class="form-label">Porcentagem de Vendas (%)</label>
                                    <input type="number" class="form-control" id="porcentagem_vendas" name="porcentagem_vendas" 
                                        value="{{ old('porcentagem_vendas', $funcionario->porcentagem_vendas) }}" min="0" max="100" step="0.01" placeholder="0.00">
                                    <small class="text-muted">Ex: 5.50 para 5,5% de comissão</small>
                                </div>
                            </div>

                            <div class="col-md-3">
                                <div class="mb-3">
                                    <div class="form-check form-switch mt-4">
                                        <input class="form-check-input" type="checkbox" id="status" name="status" value="1" 
                                            {{ old('status', $funcionario->status) ? 'checked' : '' }}>
                                        <label class="form-check-label" for="status">Status Ativo</label>
                                    </div>
                                </div>
                            </div>
                        </div>

                        <hr>

                        <div class="row">
                            <div class="col-12">
                                <div class="text-center mb-3">
                                    <button type="button" class="btn btn-secondary" id="toggleFuncoes">Habilitar Funções</button>
                                </div>
                            </div>
                        </div>

                        <div class="row" id="funcoesContainer" style="display: {{ old('funcoes') || $funcionario->funcoes ? 'block' : 'none' }};">
                            <div class="col-12">
                                <label class="form-label">Funções Habilitadas</label>
                                @php
                                    $funcoesAtuais = $funcionario->funcoes_array;
                                @endphp
                                <div class="row">
                                    <div class="col-md-4">
                                        <div class="form-check">
                                            <input class="form-check-input" type="checkbox" name="funcoes[]" value="categorias" id="categorias" {{ in_array('categorias', old('funcoes', $funcoesAtuais)) ? 'checked' : '' }}>
                                            <label class="form-check-label" for="categorias">Grupo/Categoria</label>
                                        </div>
                                        <div class="form-check">
                                            <input class="form-check-input" type="checkbox" name="funcoes[]" value="produtos" id="produtos" {{ in_array('produtos', old('funcoes', $funcoesAtuais)) ? 'checked' : '' }}>
                                            <label class="form-check-label" for="produtos">Produtos</label>
                                        </div>
                                        <div class="form-check">
                                            <input class="form-check-input" type="checkbox" name="funcoes[]" value="clientes" id="clientes" {{ in_array('clientes', old('funcoes', $funcoesAtuais)) ? 'checked' : '' }}>
                                            <label class="form-check-label" for="clientes">Clientes</label>
                                        </div>
                                        <div class="form-check">
                                            <input class="form-check-input" type="checkbox" name="funcoes[]" value="contas_receber" id="contas_receber" {{ in_array('contas_receber', old('funcoes', $funcoesAtuais)) ? 'checked' : '' }}>
                                            <label class="form-check-label" for="contas_receber">Contas a Receber</label>
                                        </div>
                                    </div>
                                    <div class="col-md-4">
                                        <div class="form-check">
                                            <input class="form-check-input" type="checkbox" name="funcoes[]" value="contas_pagar" id="contas_pagar" {{ in_array('contas_pagar', old('funcoes', $funcoesAtuais)) ? 'checked' : '' }}>
                                            <label class="form-check-label" for="contas_pagar">Contas a Pagar</label>
                                        </div>
                                        <div class="form-check">
                                            <input class="form-check-input" type="checkbox" name="funcoes[]" value="finalizados" id="finalizados" {{ in_array('finalizados', old('funcoes', $funcoesAtuais)) ? 'checked' : '' }}>
                                            <label class="form-check-label" for="finalizados">Extrato de Pagamento</label>
                                        </div>
                                        <div class="form-check">
                                            <input class="form-check-input" type="checkbox" name="funcoes[]" value="mensagens" id="mensagens" {{ in_array('mensagens', old('funcoes', $funcoesAtuais)) ? 'checked' : '' }}>
                                            <label class="form-check-label" for="mensagens">Notificações</label>
                                        </div>
                                        <div class="form-check">
                                            <input class="form-check-input" type="checkbox" name="funcoes[]" value="pdv" id="pdv" {{ in_array('pdv', old('funcoes', $funcoesAtuais)) ? 'checked' : '' }}>
                                            <label class="form-check-label" for="pdv">PDV - Caixa</label>
                                        </div>
                                    </div>
                                    <div class="col-md-4">
                                        <div class="form-check">
                                            <input class="form-check-input" type="checkbox" name="funcoes[]" value="estoque" id="estoque" {{ in_array('estoque', old('funcoes', $funcoesAtuais)) ? 'checked' : '' }}>
                                            <label class="form-check-label" for="estoque">Controle de Estoque</label>
                                        </div>
                                        <div class="form-check">
                                            <input class="form-check-input" type="checkbox" name="funcoes[]" value="vendas" id="vendas" {{ in_array('vendas', old('funcoes', $funcoesAtuais)) ? 'checked' : '' }}>
                                            <label class="form-check-label" for="vendas">Vendas</label>
                                        </div>
                                        <div class="form-check">
                                            <input class="form-check-input" type="checkbox" name="funcoes[]" value="comissoes" id="comissoes" {{ in_array('comissoes', old('funcoes', $funcoesAtuais)) ? 'checked' : '' }}>
                                            <label class="form-check-label" for="comissoes">Comissões</label>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>

                        <hr>

                        <div class="row">
                            <div class="col-12 text-center">
                                <button type="submit" class="btn btn-primary">
                                    <i class="fas fa-save"></i> Atualizar Funcionário
                                </button>
                            </div>
                        </div>
                    </form>
                </div>
            </div>
        </div>
    </div>
</div>

@push('scripts')
<script>
$(document).ready(function() {
    $('#toggleFuncoes').on('click', function() {
        $('#funcoesContainer').toggle();
    });
});
</script>
@endpush
@endsection

