@extends('layouts.app')

@section('content')
<div class="container-fluid">
    <div class="row">
        <div class="col-12">
            <div class="card">
                <div class="card-header d-flex justify-content-between align-items-center">
                    <h4>Funcionários</h4>
                    <a href="{{ route('funcionarios.create') }}" class="btn btn-primary">
                        <i class="fas fa-plus"></i> Novo Funcionário
                    </a>
                </div>
                <div class="card-body">
                    @if(session('success'))
                        <div class="alert alert-success">{{ session('success') }}</div>
                    @endif

                    @if($funcionarios->count() > 0)
                        <div class="table-responsive">
                            <table class="table table-striped">
                                <thead>
                                    <tr>
                                        <th>Nome</th>
                                        <th>Login</th>
                                        <th>Celular</th>
                                        <th>Comissão (%)</th>
                                        <th>Status</th>
                                        <th>Ações</th>
                                    </tr>
                                </thead>
                                <tbody>
                                    @foreach($funcionarios as $funcionario)
                                        <tr>
                                            <td>{{ $funcionario->nome }}</td>
                                            <td>{{ $funcionario->login }}</td>
                                            <td>{{ $funcionario->celular ?? '-' }}</td>
                                            <td>{{ number_format($funcionario->porcentagem_vendas, 2, ',', '.') }}%</td>
                                            <td>
                                                @if($funcionario->status)
                                                    <span class="badge bg-success">Ativo</span>
                                                @else
                                                    <span class="badge bg-danger">Inativo</span>
                                                @endif
                                            </td>
                                            <td>
                                                <a href="{{ route('funcionarios.show', $funcionario->id) }}" class="btn btn-sm btn-info" title="Ver detalhes">
                                                    <i class="fas fa-eye"></i>
                                                </a>
                                                <a href="{{ route('funcionarios.edit', $funcionario->id) }}" class="btn btn-sm btn-primary" title="Editar">
                                                    <i class="fas fa-edit"></i>
                                                </a>
                                                <form action="{{ route('funcionarios.destroy', $funcionario->id) }}" method="POST" style="display: inline;" 
                                                    onsubmit="return confirm('Tem certeza que deseja excluir este funcionário?');">
                                                    @csrf
                                                    @method('DELETE')
                                                    <button type="submit" class="btn btn-sm btn-danger" title="Excluir">
                                                        <i class="fas fa-trash"></i>
                                                    </button>
                                                </form>
                                            </td>
                                        </tr>
                                    @endforeach
                                </tbody>
                            </table>
                        </div>
                    @else
                        <div class="alert alert-info">
                            Nenhum funcionário cadastrado. <a href="{{ route('funcionarios.create') }}">Cadastre o primeiro funcionário</a>.
                        </div>
                    @endif
                </div>
            </div>
        </div>
    </div>
</div>
@endsection

