@php
    $superAdmin = \App\Models\Carteira::find(1);
    $nomeSistema = $superAdmin ? $superAdmin->nomecom : config('app.name');
    $favicon = $superAdmin && $superAdmin->favicon ? asset($superAdmin->favicon) : asset('img/favicon_default.png');
    
    // Verificar dark mode - usar theme se existir, senão usar dark_mode
    $isDarkMode = Auth::user()->theme === 'dark' || (Auth::user()->dark_mode ?? false);
    $themeValue = Auth::user()->theme ?? ($isDarkMode ? 'dark' : 'light');
    
    // Verificar expiração de licença
    $user = Auth::user();
    $hoje = \Carbon\Carbon::now();
    $dataExpiracao = $user->assinatura ? \Carbon\Carbon::createFromFormat('d/m/Y', $user->assinatura) : null;
    $paginaAtual = request()->path();
@endphp

<!DOCTYPE html>
<html lang="pt-BR" data-theme="{{ $themeValue }}">

@include('partials.head')

<body>
    <!-- Loader -->
    <div id="loader" style="position: fixed; width: 100%; height: 100%; background: white; display: flex; align-items: center; justify-content: center; z-index: 9999;">
        <div class="col-3" style="display: flex; align-items: center; justify-content: center;">
            <div class="snippet" data-title="loader">
                <div class="stage">
                    <div class="loader"></div>
                </div>
            </div>
        </div>
    </div>

    @include('layouts.sidebar')

    <main class="dashboard-main">
        @include('partials.navbar')

        <div class="dashboard-main-body">
            @yield('content')
        </div>

        @include('partials.footer')
    </main>

    @include('partials.scripts')
    
    @stack('scripts')

    {{-- Modal de Licença Expirada (apenas para não-superadmin e não-funcionário) --}}
    @if(
        $user->tipo != 1 && // Não é superadmin
        !session('is_funcionario') && // Não é funcionário
        $dataExpiracao && $hoje->greaterThanOrEqualTo($dataExpiracao) &&
        $paginaAtual != 'master/planos' &&
        !Str::contains($paginaAtual, 'sair')
    )
        <!-- MODAL BLOQUEADO DE LICENÇA EXPIRADA -->
        <div id="modalLicencaExpirada" class="modal fade" tabindex="-1" role="dialog">
            <div class="modal-dialog modal-dialog-centered">
                <div class="modal-content">
                    <div class="modal-header bg-danger text-white">
                        <h5 class="modal-title">Licença Expirada</h5>
                    </div>
                    <div class="modal-body">
                        <p>Sua licença expirou. Renove agora para continuar usando os serviços.</p>
                    </div>
                    <div class="modal-footer">
                        <button id="btnRenovar" class="btn btn-danger">Renovar agora</button>
                    </div>
                </div>
            </div>
        </div>

        <script>
            document.addEventListener("DOMContentLoaded", function () {
                setTimeout(function () {
                    if (typeof $ !== "undefined" && typeof $.fn.modal !== "undefined") {
                        const $modal = $('#modalLicencaExpirada');
                        $modal.modal({
                            backdrop: 'static',
                            keyboard: false
                        });
                        $modal.modal('show');
                        document.getElementById("btnRenovar").addEventListener("click", function () {
                            window.location.href = "{{ route('planos.index') }}";
                        });
                    } else {
                        window.location.href = "{{ route('planos.index') }}";
                    }
                }, 300);
            });
        </script>
    @endif

    <script>
        // Dark Mode Toggle
        function toggleDarkMode() {
            var body = document.body;
            var html = document.documentElement;
            var icon = document.getElementById('darkModeIcon');
            
            body.classList.toggle('dark-mode');
            var newTheme = body.classList.contains('dark-mode') ? 'dark' : 'light';
            html.setAttribute('data-theme', newTheme);
            
            if (newTheme === 'dark') {
                icon.src = "{{ asset('icon/luaa.png') }}";
            } else {
                icon.src = "{{ asset('icon/sol.png') }}";
            }
            
            localStorage.setItem('mode', newTheme);
            
            // Salva no banco via Ajax
            $.ajax({
                url: '{{ route("configuracoes.toggle-theme") }}',
                type: 'POST',
                data: {
                    _token: '{{ csrf_token() }}'
                },
                success: function(response) {
                    console.log('Tema alterado para: ' + response.theme);
                }
            });
        }

        // Load Dark Mode Preference
        window.onload = function() {
            var body = document.body;
            var html = document.documentElement;
            var icon = document.getElementById('darkModeIcon');
            var mode = localStorage.getItem('mode') || '{{ $themeValue }}';
            
            if (mode === 'dark') {
                body.classList.add('dark-mode');
                html.setAttribute('data-theme', 'dark');
                if (icon) icon.src = "{{ asset('icon/luaa.png') }}";
            } else {
                body.classList.remove('dark-mode');
                html.setAttribute('data-theme', 'light');
                if (icon) icon.src = "{{ asset('icon/sol.png') }}";
            }
            
            // Hide loader
            setTimeout(function() {
                var loader = document.getElementById('loader');
                if (loader) loader.style.display = 'none';
            }, 1000);
        }

        // Confirm delete
        function pergunta() {
            return confirm('Tem certeza que deseja excluir?');
        }
    </script>
</body>
</html>
