@php
    use App\Helpers\MenuHelper;
    
    $menuItems = MenuHelper::getMenuItems();
    $user = Auth::user();
    $userRole = $user->tipo == '1' ? 'superadmin' : ($user->roles ?? 'master');
    
    // Logo dinâmico - usar ID do usuário atual
    $userId = $user->id;
    $logoPathLight = "master/img/logo_light_{$userId}.png";
    $logoPathDark = "master/img/logo_dark_{$userId}.png";
    
    // Verificar se os arquivos existem
    $localFilePathLight = public_path($logoPathLight);
    $localFilePathDark = public_path($logoPathDark);
    
    $defaultLogoLight = asset('master/img/logo_light_88.png');
    $defaultLogoDark = asset('master/img/logo_dark_88.png');
    
    // Usar logo personalizada se existir, senão usar padrão
    $logoUrlLight = file_exists($localFilePathLight) ? asset($logoPathLight) : $defaultLogoLight;
    $logoUrlDark = file_exists($localFilePathDark) ? asset($logoPathDark) : $defaultLogoDark;
    
    // Verificar se é funcionário e buscar as funções habilitadas
    $funcoes = [];
    if (session('is_funcionario') && session('funcionario_id')) {
        $funcionario = \App\Models\Funcionario::find(session('funcionario_id'));
        if ($funcionario && $funcionario->funcoes) {
            $funcoes = explode(',', $funcionario->funcoes);
            $funcoes = array_map('trim', $funcoes);
        }
        $userRole = 'funcionario';
    }
@endphp

<aside class="sidebar">
    <button type="button" class="sidebar-close-btn">
        <iconify-icon icon="radix-icons:cross-2"></iconify-icon>
    </button>
    <div>
        <a href="{{ route('dashboard') }}" class="sidebar-logo">
            @php
                // Logo dinâmico baseado no ID do usuário (igual ao legado)
                $userId = $user->id;
                $logoPath = "master/img/logo{$userId}.png";
                $logoUrl = file_exists(public_path($logoPath)) ? asset($logoPath) : asset('master/img/logo88.png');
            @endphp
            <img src="{{ $logoUrl }}" alt="site logo" class="light-logo">
            <img src="{{ $logoUrl }}" alt="site logo" class="dark-logo">
            <img src="{{ $logoUrl }}" alt="site logo" class="logo-icon">
        </a>
    </div>
    <div class="sidebar-menu-area">
        <ul class="sidebar-menu" id="sidebar-menu">
            @foreach($menuItems as $item)
                @php
                    $temSubmenu = isset($item['submenu']);
                    $temGroupTitle = isset($item['group_title']);
                @endphp

                @if($temSubmenu)
                    <!-- MENU COM SUBMENU (tipo: submenu) -->
                    <li class="dropdown">
                        <a href="{{ $item['path'] }}">
                            <iconify-icon icon="{{ $item['icon'] }}" class="menu-icon"></iconify-icon>
                            <span>{{ $item['name'] }}</span>
                        </a>
                        <ul class="sidebar-submenu">
                            @foreach($item['submenu'] as $submenu)
                                <li>
                                    <a href="{{ $submenu['path'] }}">
                                        <i class="ri-circle-fill circle-icon {{ $submenu['colorIcon'] ?? 'text-primary-600' }} w-auto"></i>
                                        {{ $submenu['name'] }}
                                    </a>
                                </li>
                            @endforeach
                        </ul>
                    </li>

                @elseif($temGroupTitle)
                    @php
                        // Verificar se o grupo deve ser visível
                        $groupVisible = false;
                        foreach ($item['group_title'] as $groupItem) {
                            if ($userRole == "superadmin" || !isset($groupItem['funcao']) || in_array($groupItem['funcao'], $funcoes)) {
                                $groupVisible = true;
                                break;
                            }
                        }
                    @endphp
                    @if($groupVisible)
                        <!-- MENU COM GRUPO (tipo: group_title) - Estrutura igual ao legado com dropdown -->
                        <li class="dropdown">
                            <a href="javascript:void(0)">
                                <iconify-icon icon="{{ $item['icon'] }}" class="menu-icon"></iconify-icon>
                                <span>{{ $item['name'] }}</span>
                            </a>
                            <ul class="sidebar-submenu">
                                @foreach($item['group_title'] as $groupItem)
                                    @php
                                        // Verificar se o item deve ser visível
                                        $itemVisible = false;
                                        if ($userRole == "superadmin" || !isset($groupItem['funcao']) || in_array($groupItem['funcao'], $funcoes)) {
                                            $itemVisible = true;
                                        }
                                    @endphp
                                    @if($itemVisible)
                                        <li>
                                            <a href="{{ $groupItem['path'] }}">
                                                <iconify-icon icon="{{ $groupItem['icon'] }}" class="menu-icon"></iconify-icon>
                                                <span>{{ $groupItem['name'] }}</span>
                                            </a>
                                        </li>
                                    @endif
                                @endforeach
                            </ul>
                        </li>
                    @endif

                @else
                    @php
                        // Verificar se o item deve ser visível
                        $itemVisible = false;
                        if ($userRole == "superadmin" || !isset($item['funcao']) || in_array($item['funcao'], $funcoes)) {
                            $itemVisible = true;
                        }
                    @endphp
                    @if($itemVisible)
                        <!-- ITEM SIMPLES -->
                        <li>
                            <a href="{{ $item['path'] }}">
                                <iconify-icon icon="{{ $item['icon'] }}" class="menu-icon"></iconify-icon>
                                <span>{{ $item['name'] }}</span>
                            </a>
                        </li>
                    @endif
                @endif
            @endforeach
        </ul>
    </div>
</aside>

<script>
// Script para ajustar o logo-icon de acordo com o modo atual
document.addEventListener('DOMContentLoaded', function() {
    const logoIcon = document.querySelector('.logo-icon');
    const lightLogoUrl = '{{ $logoUrlLight }}';
    const darkLogoUrl = '{{ $logoUrlDark }}';
    
    if (!logoIcon) return;
    
    // Função para verificar se está no modo escuro
    function isDarkMode() {
        return document.documentElement.getAttribute('data-theme') === 'dark' || 
               document.body.classList.contains('dark-mode');
    }
    
    // Função para atualizar o ícone da logo
    function updateLogoIcon() {
        if (isDarkMode()) {
            logoIcon.src = darkLogoUrl;
        } else {
            logoIcon.src = lightLogoUrl;
        }
    }
    
    // Atualizar na carga inicial
    updateLogoIcon();
    
    // Observar mudanças no atributo data-theme
    const observer = new MutationObserver(function(mutations) {
        mutations.forEach(function(mutation) {
            if (mutation.type === 'attributes' && mutation.attributeName === 'data-theme') {
                updateLogoIcon();
            }
        });
    });
    
    // Observar mudanças no html
    observer.observe(document.documentElement, { attributes: true, attributeFilter: ['data-theme'] });
    
    // Observar mudanças na classe dark-mode do body
    const bodyObserver = new MutationObserver(function(mutations) {
        mutations.forEach(function(mutation) {
            if (mutation.type === 'attributes' && mutation.attributeName === 'class') {
                updateLogoIcon();
            }
        });
    });
    
    bodyObserver.observe(document.body, { attributes: true, attributeFilter: ['class'] });
});

// Garantir que os submenus comecem fechados
document.addEventListener('DOMContentLoaded', function() {
    // Esconder todos os submenus por padrão
    var submenus = document.querySelectorAll('.sidebar-submenu');
    submenus.forEach(function(submenu) {
        submenu.style.display = 'none';
    });
});
</script>
