@extends('layouts.app')

@section('title', 'Editar Mensagem')

@section('content')
<div class="slim-mainpanel">
    <div class="container">
        <div class="section-wrapper mg-t-20">
            <label class="section-title">
                <i class="fa fa-pencil-square" aria-hidden="true"></i> Editar Mensagem
            </label>
            <hr>

            <form action="{{ route('mensagens.update', $mensagem->id) }}" method="POST">
                @csrf
                @method('PUT')
                
                <input type="hidden" name="idu" value="{{ $mensagem->idu }}">

                <div class="form-group">
                    <label for="tipo">Tipo de Mensagem <span class="tx-danger">*</span></label>
                    <select class="form-control" id="tipo" name="tipo" required>
                        <option value="">Selecione...</option>
                        <option value="1" {{ $mensagem->tipo == '1' ? 'selected' : '' }}>5 dias antes do vencimento</option>
                        <option value="2" {{ $mensagem->tipo == '2' ? 'selected' : '' }}>3 dias antes do vencimento</option>
                        <option value="3" {{ $mensagem->tipo == '3' ? 'selected' : '' }}>No dia do vencimento</option>
                        <option value="4" {{ $mensagem->tipo == '4' ? 'selected' : '' }}>Parcela vencida (atraso)</option>
                        <option value="5" {{ $mensagem->tipo == '5' ? 'selected' : '' }}>Recibo de pagamento</option>
                        <option value="6" {{ $mensagem->tipo == '6' ? 'selected' : '' }}>Mensagem personalizada</option>
                        <option value="7" {{ $mensagem->tipo == '7' ? 'selected' : '' }}>7 dias antes do vencimento</option>
                    </select>
                    <small class="form-text text-muted">
                        Escolha quando esta mensagem será enviada automaticamente
                    </small>
                </div>

                <div class="form-group">
                    <label for="hora">Horário de Envio <span class="tx-danger">*</span></label>
                    <input type="time" class="form-control" id="hora" name="hora" value="{{ old('hora', $mensagem->hora) }}" required>
                    <small class="form-text text-muted">
                        Horário em que a mensagem será enviada (formato 24 horas)
                    </small>
                </div>

                <div class="form-group">
                    <label for="msg">Mensagem <span class="tx-danger">*</span></label>
                    <textarea class="form-control" id="msg" name="msg" rows="8" required>{{ old('msg', $mensagem->msg) }}</textarea>
                    <small class="form-text text-muted">
                        <strong>Variáveis disponíveis:</strong><br>
                        #NOME# - Nome do cliente<br>
                        #VALOR# - Valor da parcela<br>
                        #VENCIMENTO# - Data de vencimento<br>
                        #LINK# - Link de pagamento<br>
                        #EMPRESA# - Nome da empresa<br>
                        #CNPJ# - CNPJ da empresa<br>
                        #ENDERECO# - Endereço da empresa<br>
                        #CONTATO# - Telefone de contato
                    </small>
                </div>

                <div class="form-group">
                    <label for="status">Status <span class="tx-danger">*</span></label>
                    <select class="form-control" id="status" name="status" required>
                        <option value="1" {{ $mensagem->status == '1' ? 'selected' : '' }}>Ativa (será enviada)</option>
                        <option value="0" {{ $mensagem->status == '0' ? 'selected' : '' }}>Inativa (não será enviada)</option>
                    </select>
                </div>

                <div class="form-group mg-t-20">
                    <button type="submit" class="btn btn-success">
                        <i class="fa fa-check mg-r-5"></i> Atualizar
                    </button>
                    <a href="{{ route('mensagens.index') }}" class="btn btn-secondary">
                        <i class="fa fa-arrow-left mg-r-5"></i> Voltar
                    </a>
                </div>
            </form>
        </div>
    </div>
</div>
@endsection

