@php
    // Buscar celular do super admin (role = superadmin)
    $admin = \App\Models\Carteira::where('tipo', '1')->first();
    $whatsappNumber = $admin && $admin->contato ? preg_replace('/\D/', '', $admin->contato) : '5541998608485';
    $mensagemTexto = $admin && $admin->mensagem_ajuda ? $admin->mensagem_ajuda : 'Preciso de ajuda Gestor Pro+';
    $mensagem = urlencode($mensagemTexto);
    
    // Buscar foto de perfil do usuário
    $fotoPerfil = Auth::user()->foto_perfil 
        ? asset(Auth::user()->foto_perfil) 
        : asset('icon/userativo.png');
@endphp

<div class="navbar-header">
    <div class="row align-items-center justify-content-between">
        <div class="col-auto">
            <div class="d-flex flex-wrap align-items-center gap-4">
                <button type="button" class="sidebar-toggle">
                    <iconify-icon icon="heroicons:bars-3-solid" class="icon text-2xl non-active"></iconify-icon>
                    <iconify-icon icon="iconoir:arrow-right" class="icon text-2xl active"></iconify-icon>
                </button>
                <button type="button" class="sidebar-mobile-toggle">
                    <iconify-icon icon="heroicons:bars-3-solid" class="icon"></iconify-icon>
                </button>
            </div>
        </div>
        <div class="col-auto">
            <div class="d-flex flex-wrap align-items-center gap-3">
                <button type="button" data-theme-toggle onclick="toggleDarkMode()" class="w-40-px h-40-px bg-neutral-200 rounded-circle d-flex justify-content-center align-items-center">
                    <img id="darkModeIcon" src="{{ asset('icon/sol.png') }}" style="width: 20px; height: 20px;" alt="Dark Mode">
                </button>
                
                <!-- Botão de ajuda via WhatsApp -->
                <a href="https://wa.me/{{ $whatsappNumber }}?text={{ $mensagem }}" 
                   target="_blank"
                   class="w-40-px h-40-px bg-success-100 rounded-circle d-flex justify-content-center align-items-center"
                   title="{{ htmlspecialchars($mensagemTexto) }}">
                   <iconify-icon icon="tabler:help" class="icon text-xl text-success-dark"></iconify-icon>
                </a>

                <div class="dropdown">
                    <button class="d-flex justify-content-center align-items-center rounded-circle" type="button" data-bs-toggle="dropdown">
                        <img src="{{ $fotoPerfil }}" alt="Foto de Perfil" class="w-40-px h-40-px object-fit-cover rounded-circle">
                    </button>
                    <div class="dropdown-menu to-top dropdown-menu-sm">
                        <div class="py-12 px-16 radius-8 bg-primary-50 mb-16 d-flex align-items-center justify-content-between gap-2">
                            <div>
                                <h6 class="text-lg text-primary-light fw-semibold mb-2">{{ Auth::user()->nomecom ?? Auth::user()->nome }}</h6>
                                <span class="text-secondary-light fw-medium text-sm">{{ Auth::user()->nome }}</span>
                            </div>
                            <button type="button" class="hover-text-danger">
                                <iconify-icon icon="radix-icons:cross-1" class="icon text-xl"></iconify-icon>
                            </button>
                        </div>
                        <ul class="to-top-list">
                            <li>
                                <a class="dropdown-item text-black px-0 py-8 hover-bg-transparent hover-text-primary d-flex align-items-center gap-3" href="{{ route('perfil') }}">
                                    <iconify-icon icon="solar:user-linear" class="icon text-xl"></iconify-icon> Meu Perfil
                                </a>
                            </li>
                            <li>
                                <a class="dropdown-item text-black px-0 py-8 hover-bg-transparent hover-text-primary d-flex align-items-center gap-3" href="{{ route('configuracoes.index') }}">
                                    <iconify-icon icon="icon-park-outline:setting-two" class="icon text-xl"></iconify-icon> Configurações
                                </a>
                            </li>
                            <li>
                                <a class="dropdown-item text-black px-0 py-8 hover-bg-transparent hover-text-danger d-flex align-items-center gap-3" href="{{ route('logout') }}">
                                    <iconify-icon icon="lucide:power" class="icon text-xl"></iconify-icon> Sair
                                </a>
                            </li>
                        </ul>
                    </div>
                </div><!-- Profile dropdown end -->
            </div>
        </div>
    </div>
</div>

