@extends('layouts.app')

@section('content')
<div class="container-fluid">
    <div class="row">
        <div class="col-12">
            <div class="card">
                <div class="card-header d-flex justify-content-between align-items-center">
                    <h4>Histórico de Caixas</h4>
                    <a href="{{ route('pdv.index') }}" class="btn btn-primary">
                        <i class="fas fa-arrow-left"></i> Voltar ao PDV
                    </a>
                </div>
                <div class="card-body">
                    @if(session('success'))
                        <div class="alert alert-success">{{ session('success') }}</div>
                    @endif

                    @if($caixas->count() > 0)
                        <div class="table-responsive">
                            <table class="table table-striped">
                                <thead>
                                    <tr>
                                        <th>ID</th>
                                        <th>Abertura</th>
                                        <th>Fechamento</th>
                                        <th>Atendente</th>
                                        <th>Saldo Inicial</th>
                                        <th>Saldo Final</th>
                                        <th>Total Vendas</th>
                                        <th>Status</th>
                                        <th>Ações</th>
                                    </tr>
                                </thead>
                                <tbody>
                                    @foreach($caixas as $caixa)
                                        <tr>
                                            <td>{{ $caixa->id }}</td>
                                            <td>{{ $caixa->abertura->format('d/m/Y H:i') }}</td>
                                            <td>{{ $caixa->fechamento ? $caixa->fechamento->format('d/m/Y H:i') : '-' }}</td>
                                            <td>{{ $caixa->atendente_nome ?? '-' }}</td>
                                            <td>R$ {{ number_format($caixa->saldo_inicial, 2, ',', '.') }}</td>
                                            <td>{{ $caixa->saldo_final ? 'R$ ' . number_format($caixa->saldo_final, 2, ',', '.') : '-' }}</td>
                                            <td>R$ {{ number_format($caixa->total_vendas, 2, ',', '.') }}</td>
                                            <td>
                                                @if($caixa->status === 'aberto')
                                                    <span class="badge bg-success">Aberto</span>
                                                @else
                                                    <span class="badge bg-secondary">Fechado</span>
                                                @endif
                                            </td>
                                            <td>
                                                @if($caixa->status === 'aberto')
                                                    <form action="{{ route('pdv.caixa.fechar', $caixa->id) }}" method="POST" style="display: inline;">
                                                        @csrf
                                                        <button type="submit" class="btn btn-sm btn-danger" onclick="return confirm('Tem certeza que deseja fechar este caixa?')">
                                                            <i class="fas fa-lock"></i> Fechar
                                                        </button>
                                                    </form>
                                                @endif
                                            </td>
                                        </tr>
                                    @endforeach
                                </tbody>
                            </table>
                        </div>

                        <div class="mt-3">
                            {{ $caixas->links() }}
                        </div>
                    @else
                        <div class="alert alert-info">
                            Nenhum caixa encontrado.
                        </div>
                    @endif
                </div>
            </div>
        </div>
    </div>
</div>
@endsection

