@extends('layouts.app')

@section('content')
<div class="container-fluid">
    <div class="row">
        <div class="col-12">
            <div class="card">
                <div class="card-header d-flex justify-content-between align-items-center">
                    <h4>Formas de Pagamento</h4>
                    <button type="button" class="btn btn-primary" data-bs-toggle="modal" data-bs-target="#modalFormaPagamento">
                        <i class="fas fa-plus"></i> Nova Forma
                    </button>
                </div>
                <div class="card-body">
                    @if(session('success'))
                        <div class="alert alert-success">{{ session('success') }}</div>
                    @endif

                    @if($formasPagamento->count() > 0)
                        <div class="table-responsive">
                            <table class="table table-striped">
                                <thead>
                                    <tr>
                                        <th>Nome</th>
                                        <th>Ações</th>
                                    </tr>
                                </thead>
                                <tbody>
                                    @foreach($formasPagamento as $fp)
                                        <tr>
                                            <td>{{ $fp->nome }}</td>
                                            <td>
                                                <button type="button" class="btn btn-sm btn-primary" 
                                                    onclick="editarFormaPagamento({{ $fp->id }}, '{{ $fp->nome }}')">
                                                    <i class="fas fa-edit"></i>
                                                </button>
                                                <form action="{{ route('pdv.formas-pagamento.destroy', $fp->id) }}" method="POST" style="display: inline;" 
                                                    onsubmit="return confirm('Tem certeza que deseja excluir esta forma de pagamento?');">
                                                    @csrf
                                                    @method('DELETE')
                                                    <button type="submit" class="btn btn-sm btn-danger">
                                                        <i class="fas fa-trash"></i>
                                                    </button>
                                                </form>
                                            </td>
                                        </tr>
                                    @endforeach
                                </tbody>
                            </table>
                        </div>
                    @else
                        <div class="alert alert-info">
                            Nenhuma forma de pagamento cadastrada. Cadastre pelo menos uma para realizar vendas.
                        </div>
                    @endif
                </div>
            </div>
        </div>
    </div>
</div>

<!-- Modal Forma de Pagamento -->
<div class="modal fade" id="modalFormaPagamento" tabindex="-1">
    <div class="modal-dialog">
        <div class="modal-content">
            <form id="formFormaPagamento" method="POST">
                @csrf
                <div id="method-field"></div>
                <div class="modal-header">
                    <h5 class="modal-title" id="modalTitle">Nova Forma de Pagamento</h5>
                    <button type="button" class="btn-close" data-bs-dismiss="modal"></button>
                </div>
                <div class="modal-body">
                    <div class="mb-3">
                        <label for="nome" class="form-label">Nome *</label>
                        <input type="text" class="form-control" id="nome" name="nome" required maxlength="50">
                    </div>
                </div>
                <div class="modal-footer">
                    <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">Cancelar</button>
                    <button type="submit" class="btn btn-primary">Salvar</button>
                </div>
            </form>
        </div>
    </div>
</div>

@push('scripts')
<script>
function editarFormaPagamento(id, nome) {
    $('#modalTitle').text('Editar Forma de Pagamento');
    $('#formFormaPagamento').attr('action', '{{ route("pdv.formas-pagamento.update", ":id") }}'.replace(':id', id));
    $('#method-field').html('<input type="hidden" name="_method" value="PUT">');
    $('#nome').val(nome);
    $('#modalFormaPagamento').modal('show');
}

$('#modalFormaPagamento').on('hidden.bs.modal', function () {
    $('#modalTitle').text('Nova Forma de Pagamento');
    $('#formFormaPagamento').attr('action', '{{ route("pdv.formas-pagamento.store") }}');
    $('#method-field').html('');
    $('#nome').val('');
});
</script>
@endpush
@endsection

