@extends('layouts.app')

@section('content')
<div class="container-fluid">
    <div class="row">
        <div class="col-12">
            <div class="card">
                <div class="card-header d-flex justify-content-between align-items-center">
                    <h4>Editar Produto</h4>
                    <a href="{{ route('pdv.produtos.index') }}" class="btn btn-secondary">
                        <i class="fas fa-arrow-left"></i> Voltar
                    </a>
                </div>
                <div class="card-body">
                    <form action="{{ route('pdv.produtos.update', $produto->id) }}" method="POST" enctype="multipart/form-data">
                        @csrf
                        @method('PUT')

                        @if($produto->imagem)
                            <div class="mb-3">
                                <label class="form-label">Imagem Atual</label>
                                <div>
                                    <img src="{{ asset($produto->imagem) }}" alt="{{ $produto->nome }}" style="max-width: 200px; max-height: 200px;">
                                </div>
                            </div>
                        @endif

                        <div class="row">
                            <div class="col-md-8">
                                <div class="mb-3">
                                    <label for="nome" class="form-label">Nome do Produto *</label>
                                    <input type="text" class="form-control" id="nome" name="nome" required value="{{ old('nome', $produto->nome) }}">
                                </div>
                            </div>
                            <div class="col-md-4">
                                <div class="mb-3">
                                    <label for="codigo_barras" class="form-label">Código de Barras</label>
                                    <input type="text" class="form-control" id="codigo_barras" name="codigo_barras" value="{{ old('codigo_barras', $produto->codigo_barras) }}">
                                </div>
                            </div>
                        </div>

                        <div class="mb-3">
                            <label for="descricao" class="form-label">Descrição</label>
                            <textarea class="form-control" id="descricao" name="descricao" rows="3">{{ old('descricao', $produto->descricao) }}</textarea>
                        </div>

                        <div class="row">
                            <div class="col-md-4">
                                <div class="mb-3">
                                    <label for="preco_venda" class="form-label">Preço de Venda *</label>
                                    <input type="number" class="form-control" id="preco_venda" name="preco_venda" step="0.01" min="0" required value="{{ old('preco_venda', $produto->preco_venda) }}">
                                </div>
                            </div>
                            <div class="col-md-4">
                                <div class="mb-3">
                                    <label for="preco_custo" class="form-label">Preço de Custo</label>
                                    <input type="number" class="form-control" id="preco_custo" name="preco_custo" step="0.01" min="0" value="{{ old('preco_custo', $produto->preco_custo) }}">
                                </div>
                            </div>
                            <div class="col-md-4">
                                <div class="mb-3">
                                    <label for="margem_lucro" class="form-label">Margem de Lucro (%)</label>
                                    <input type="number" class="form-control" id="margem_lucro" name="margem_lucro" step="0.01" readonly value="{{ old('margem_lucro', $produto->margem_lucro) }}">
                                    <small class="text-muted">Calculado automaticamente</small>
                                </div>
                            </div>
                        </div>

                        <div class="row">
                            <div class="col-md-3">
                                <div class="mb-3">
                                    <label for="estoque" class="form-label">Estoque *</label>
                                    <input type="number" class="form-control" id="estoque" name="estoque" min="0" required value="{{ old('estoque', $produto->estoque) }}">
                                </div>
                            </div>
                            <div class="col-md-3">
                                <div class="mb-3">
                                    <label for="estoque_minimo" class="form-label">Estoque Mínimo</label>
                                    <input type="number" class="form-control" id="estoque_minimo" name="estoque_minimo" min="0" value="{{ old('estoque_minimo', $produto->estoque_minimo) }}">
                                </div>
                            </div>
                            <div class="col-md-3">
                                <div class="mb-3">
                                    <label for="unidade" class="form-label">Unidade</label>
                                    <input type="text" class="form-control" id="unidade" name="unidade" value="{{ old('unidade', $produto->unidade) }}" maxlength="10">
                                </div>
                            </div>
                            <div class="col-md-3">
                                <div class="mb-3">
                                    <label class="form-label">&nbsp;</label>
                                    <div class="form-check mt-2">
                                        <input class="form-check-input" type="checkbox" id="alerta_estoque" name="alerta_estoque" value="1" {{ old('alerta_estoque', $produto->alerta_estoque) ? 'checked' : '' }}>
                                        <label class="form-check-label" for="alerta_estoque">
                                            Alerta de estoque baixo
                                        </label>
                                    </div>
                                </div>
                            </div>
                        </div>

                        <div class="row">
                            <div class="col-md-4">
                                <div class="mb-3">
                                    <label for="categoria_id" class="form-label">Categoria</label>
                                    <select class="form-select" id="categoria_id" name="categoria_id">
                                        <option value="">Selecione...</option>
                                        @foreach($categorias as $categoria)
                                            <option value="{{ $categoria->id }}" {{ old('categoria_id', $produto->categoria_id) == $categoria->id ? 'selected' : '' }}>
                                                {{ $categoria->nome }}
                                            </option>
                                        @endforeach
                                    </select>
                                </div>
                            </div>
                            <div class="col-md-4">
                                <div class="mb-3">
                                    <label for="fornecedor_id" class="form-label">Fornecedor</label>
                                    <select class="form-select" id="fornecedor_id" name="fornecedor_id">
                                        <option value="">Selecione...</option>
                                        @foreach($fornecedores as $fornecedor)
                                            <option value="{{ $fornecedor->id }}" {{ old('fornecedor_id', $produto->fornecedor_id) == $fornecedor->id ? 'selected' : '' }}>
                                                {{ $fornecedor->nome }}
                                            </option>
                                        @endforeach
                                    </select>
                                </div>
                            </div>
                            <div class="col-md-4">
                                <div class="mb-3">
                                    <label for="fabricante" class="form-label">Fabricante</label>
                                    <input type="text" class="form-control" id="fabricante" name="fabricante" value="{{ old('fabricante', $produto->fabricante) }}">
                                </div>
                            </div>
                        </div>

                        <div class="row">
                            <div class="col-md-3">
                                <div class="mb-3">
                                    <label for="peso" class="form-label">Peso (kg)</label>
                                    <input type="number" class="form-control" id="peso" name="peso" step="0.01" min="0" value="{{ old('peso', $produto->peso) }}">
                                </div>
                            </div>
                            <div class="col-md-3">
                                <div class="mb-3">
                                    <label for="ncm" class="form-label">NCM</label>
                                    <input type="text" class="form-control" id="ncm" name="ncm" maxlength="20" value="{{ old('ncm', $produto->ncm) }}">
                                </div>
                            </div>
                            <div class="col-md-3">
                                <div class="mb-3">
                                    <label for="cfop" class="form-label">CFOP</label>
                                    <input type="text" class="form-control" id="cfop" name="cfop" maxlength="10" value="{{ old('cfop', $produto->cfop) }}">
                                </div>
                            </div>
                            <div class="col-md-3">
                                <div class="mb-3">
                                    <label for="imagem" class="form-label">Nova Imagem</label>
                                    <input type="file" class="form-control" id="imagem" name="imagem" accept="image/*">
                                    <small class="text-muted">Deixe em branco para manter a imagem atual</small>
                                </div>
                            </div>
                        </div>

                        <div class="mt-3">
                            <button type="submit" class="btn btn-primary">
                                <i class="fas fa-save"></i> Atualizar Produto
                            </button>
                            <a href="{{ route('pdv.produtos.index') }}" class="btn btn-secondary">Cancelar</a>
                        </div>
                    </form>
                </div>
            </div>
        </div>
    </div>
</div>

@push('scripts')
<script>
// Calcular margem de lucro automaticamente
document.getElementById('preco_custo').addEventListener('input', calcularMargem);
document.getElementById('preco_venda').addEventListener('input', calcularMargem);

function calcularMargem() {
    const precoCusto = parseFloat(document.getElementById('preco_custo').value) || 0;
    const precoVenda = parseFloat(document.getElementById('preco_venda').value) || 0;
    
    if (precoCusto > 0 && precoVenda > 0) {
        const margem = ((precoVenda - precoCusto) / precoCusto) * 100;
        document.getElementById('margem_lucro').value = margem.toFixed(2);
    } else {
        document.getElementById('margem_lucro').value = '';
    }
}

// Calcular ao carregar
calcularMargem();
</script>
@endpush
@endsection

