@extends('layouts.app')

@section('content')
<div class="container-fluid">
    <div class="row">
        <div class="col-12">
            <div class="card">
                <div class="card-header d-flex justify-content-between align-items-center">
                    <h4>Produtos</h4>
                    <a href="{{ route('pdv.produtos.create') }}" class="btn btn-primary">
                        <i class="fas fa-plus"></i> Novo Produto
                    </a>
                </div>
                <div class="card-body">
                    @if(session('success'))
                        <div class="alert alert-success">{{ session('success') }}</div>
                    @endif

                    <!-- Filtros -->
                    <form method="GET" action="{{ route('pdv.produtos.index') }}" class="mb-3">
                        <div class="row">
                            <div class="col-md-4">
                                <input type="text" name="busca" class="form-control" placeholder="Buscar por nome ou código de barras" value="{{ request('busca') }}">
                            </div>
                            <div class="col-md-3">
                                <select name="categoria_id" class="form-select">
                                    <option value="">Todas as categorias</option>
                                    @foreach($categorias as $categoria)
                                        <option value="{{ $categoria->id }}" {{ request('categoria_id') == $categoria->id ? 'selected' : '' }}>
                                            {{ $categoria->nome }}
                                        </option>
                                    @endforeach
                                </select>
                            </div>
                            <div class="col-md-2">
                                <label class="form-check-label">
                                    <input type="checkbox" name="estoque_baixo" value="1" {{ request('estoque_baixo') ? 'checked' : '' }} class="form-check-input">
                                    Estoque baixo
                                </label>
                            </div>
                            <div class="col-md-3">
                                <button type="submit" class="btn btn-secondary">Filtrar</button>
                                <a href="{{ route('pdv.produtos.index') }}" class="btn btn-outline-secondary">Limpar</a>
                            </div>
                        </div>
                    </form>

                    @if($produtos->count() > 0)
                        <div class="table-responsive">
                            <table class="table table-striped">
                                <thead>
                                    <tr>
                                        <th>Imagem</th>
                                        <th>Nome</th>
                                        <th>Código</th>
                                        <th>Categoria</th>
                                        <th>Preço Venda</th>
                                        <th>Estoque</th>
                                        <th>Status</th>
                                        <th>Ações</th>
                                    </tr>
                                </thead>
                                <tbody>
                                    @foreach($produtos as $produto)
                                        <tr>
                                            <td>
                                                @if($produto->imagem)
                                                    <img src="{{ asset($produto->imagem) }}" alt="{{ $produto->nome }}" style="width: 50px; height: 50px; object-fit: cover;">
                                                @else
                                                    <div class="bg-light d-flex align-items-center justify-content-center" style="width: 50px; height: 50px;">
                                                        <i class="fas fa-image text-muted"></i>
                                                    </div>
                                                @endif
                                            </td>
                                            <td>{{ $produto->nome }}</td>
                                            <td>{{ $produto->codigo_barras ?? '-' }}</td>
                                            <td>{{ $produto->categoria->nome ?? '-' }}</td>
                                            <td>R$ {{ number_format($produto->preco_venda, 2, ',', '.') }}</td>
                                            <td>
                                                <span class="{{ $produto->isEstoqueBaixo() ? 'text-danger fw-bold' : '' }}">
                                                    {{ $produto->estoque }}
                                                </span>
                                                @if($produto->isEstoqueBaixo())
                                                    <i class="fas fa-exclamation-triangle text-danger" title="Estoque baixo!"></i>
                                                @endif
                                            </td>
                                            <td>
                                                @if($produto->isEstoqueBaixo())
                                                    <span class="badge bg-warning">Estoque Baixo</span>
                                                @else
                                                    <span class="badge bg-success">OK</span>
                                                @endif
                                            </td>
                                            <td>
                                                <a href="{{ route('pdv.produtos.edit', $produto->id) }}" class="btn btn-sm btn-primary">
                                                    <i class="fas fa-edit"></i>
                                                </a>
                                                <form action="{{ route('pdv.produtos.destroy', $produto->id) }}" method="POST" style="display: inline;" onsubmit="return confirm('Tem certeza que deseja excluir este produto?');">
                                                    @csrf
                                                    @method('DELETE')
                                                    <button type="submit" class="btn btn-sm btn-danger">
                                                        <i class="fas fa-trash"></i>
                                                    </button>
                                                </form>
                                            </td>
                                        </tr>
                                    @endforeach
                                </tbody>
                            </table>
                        </div>

                        <div class="mt-3">
                            {{ $produtos->links() }}
                        </div>
                    @else
                        <div class="alert alert-info">
                            Nenhum produto encontrado.
                        </div>
                    @endif
                </div>
            </div>
        </div>
    </div>
</div>
@endsection

