@extends('layouts.app')

@section('content')
<div class="container-fluid">
    <div class="row">
        <div class="col-12">
            <div class="card">
                <div class="card-header d-flex justify-content-between align-items-center">
                    <h4>Vendas Realizadas</h4>
                    <a href="{{ route('pdv.vendas.create') }}" class="btn btn-primary">
                        <i class="fas fa-plus"></i> Nova Venda
                    </a>
                </div>
                <div class="card-body">
                    @if(session('success'))
                        <div class="alert alert-success">{{ session('success') }}</div>
                    @endif

                    <!-- Filtros -->
                    <form method="GET" action="{{ route('pdv.vendas.index') }}" class="mb-3">
                        <div class="row">
                            <div class="col-md-3">
                                <label for="data_inicio" class="form-label">Data Início</label>
                                <input type="date" name="data_inicio" class="form-control" value="{{ request('data_inicio') }}">
                            </div>
                            <div class="col-md-3">
                                <label for="data_fim" class="form-label">Data Fim</label>
                                <input type="date" name="data_fim" class="form-control" value="{{ request('data_fim') }}">
                            </div>
                            <div class="col-md-3">
                                <label for="status" class="form-label">Status</label>
                                <select name="status" class="form-select">
                                    <option value="">Todos</option>
                                    <option value="ativa" {{ request('status') == 'ativa' ? 'selected' : '' }}>Ativa</option>
                                    <option value="cancelada" {{ request('status') == 'cancelada' ? 'selected' : '' }}>Cancelada</option>
                                    <option value="trocada" {{ request('status') == 'trocada' ? 'selected' : '' }}>Trocada</option>
                                </select>
                            </div>
                            <div class="col-md-3">
                                <label class="form-label">&nbsp;</label>
                                <div>
                                    <button type="submit" class="btn btn-secondary">Filtrar</button>
                                    <a href="{{ route('pdv.vendas.index') }}" class="btn btn-outline-secondary">Limpar</a>
                                </div>
                            </div>
                        </div>
                    </form>

                    @if($vendas->count() > 0)
                        <div class="table-responsive">
                            <table class="table table-striped">
                                <thead>
                                    <tr>
                                        <th>ID</th>
                                        <th>Data</th>
                                        <th>Cliente</th>
                                        <th>Total</th>
                                        <th>Forma Pagamento</th>
                                        <th>Status</th>
                                        <th>Ações</th>
                                    </tr>
                                </thead>
                                <tbody>
                                    @foreach($vendas as $venda)
                                        <tr>
                                            <td>#{{ $venda->id }}</td>
                                            <td>{{ $venda->data_venda->format('d/m/Y H:i') }}</td>
                                            <td>{{ $venda->cliente->nome ?? 'Cliente não informado' }}</td>
                                            <td>R$ {{ number_format($venda->total, 2, ',', '.') }}</td>
                                            <td>{{ $venda->forma_pagamento }}</td>
                                            <td>
                                                @if($venda->status === 'ativa')
                                                    <span class="badge bg-success">Ativa</span>
                                                @elseif($venda->status === 'cancelada')
                                                    <span class="badge bg-danger">Cancelada</span>
                                                @else
                                                    <span class="badge bg-warning">Trocada</span>
                                                @endif
                                            </td>
                                            <td>
                                                <a href="{{ route('pdv.vendas.show', $venda->id) }}" class="btn btn-sm btn-info">
                                                    <i class="fas fa-eye"></i>
                                                </a>
                                                @if($venda->status === 'ativa')
                                                    <form action="{{ route('pdv.vendas.cancelar', $venda->id) }}" method="POST" style="display: inline;" onsubmit="return confirm('Tem certeza que deseja cancelar esta venda?');">
                                                        @csrf
                                                        <button type="submit" class="btn btn-sm btn-danger">
                                                            <i class="fas fa-times"></i>
                                                        </button>
                                                    </form>
                                                @endif
                                            </td>
                                        </tr>
                                    @endforeach
                                </tbody>
                            </table>
                        </div>

                        <div class="mt-3">
                            {{ $vendas->links() }}
                        </div>
                    @else
                        <div class="alert alert-info">
                            Nenhuma venda encontrada.
                        </div>
                    @endif
                </div>
            </div>
        </div>
    </div>
</div>
@endsection

