@extends('layouts.app')

@section('title', 'Gerenciar Planos')

@section('content')
<div class="slim-mainpanel">
    <div class="container">
        <div align="right" class="mg-b-10">
            <button type="button" class="btn btn-primary btn-sm" data-toggle="modal" data-target="#modalNovoPlano">
                <i class="fa fa-plus mg-r-10" aria-hidden="true"></i>NOVO PLANO
            </button>
        </div>

        @if(session('success'))
        <div class="alert alert-solid alert-success" role="alert">
            <strong>Sucesso!</strong> {{ session('success') }}
        </div>
        @endif

        <div class="section-wrapper">
            <label class="section-title">
                <i class="fa fa-cog" aria-hidden="true"></i> Gerenciar Planos
            </label>
            <hr>
            
            <div class="table-wrapper">
                <table id="datatable1" class="table display responsive nowrap" width="100%">
                    <thead>
                        <tr>
                            <th>#</th>
                            <th>Nome</th>
                            <th>Valor</th>
                            <th>Status</th>
                            <th>Destaque</th>
                            <th></th>
                            <th></th>
                        </tr>
                    </thead>
                    <tbody>
                        @foreach($planos as $plano)
                        <tr>
                            <td>{{ $plano->id }}</td>
                            <td>{{ $plano->nome }}</td>
                            <td>R$ {{ number_format($plano->valor, 2, ',', '.') }}</td>
                            <td>
                                @if($plano->ativo == '1')
                                    <span class="badge badge-success">Ativo</span>
                                @else
                                    <span class="badge badge-secondary">Inativo</span>
                                @endif
                            </td>
                            <td>
                                @if($plano->destaque == '1')
                                    <i class="fa fa-star tx-warning"></i>
                                @endif
                            </td>
                            <td align="center">
                                <button type="button" class="btn btn-warning btn-sm" onclick="editarPlano({{ $plano->id }}, '{{ $plano->nome }}', {{ $plano->valor }}, '{{ addslashes($plano->descricao) }}', '{{ $plano->ativo }}', '{{ $plano->destaque }}')">
                                    <i class="icon fa fa-pencil-square"></i>
                                </button>
                            </td>
                            <td align="center">
                                <form action="{{ route('planos.destroy', $plano->id) }}" method="POST" style="display: inline;">
                                    @csrf
                                    @method('DELETE')
                                    <button type="submit" class="btn btn-danger btn-sm" onclick="return confirm('Tem certeza?')">
                                        <i class="icon fa fa-times"></i>
                                    </button>
                                </form>
                            </td>
                        </tr>
                        @endforeach
                    </tbody>
                </table>
            </div>
        </div>
    </div>
</div>

<!-- Modal Novo Plano -->
<div class="modal fade" id="modalNovoPlano" tabindex="-1" role="dialog">
    <div class="modal-dialog" role="document">
        <div class="modal-content">
            <div class="modal-header">
                <h5 class="modal-title">Novo Plano</h5>
                <button type="button" class="close" data-dismiss="modal">
                    <span>&times;</span>
                </button>
            </div>
            <form action="{{ route('planos.store') }}" method="POST">
                @csrf
                <div class="modal-body">
                    <div class="form-group">
                        <label for="nome">Nome do Plano</label>
                        <input type="text" class="form-control" name="nome" required>
                    </div>
                    <div class="form-group">
                        <label for="valor">Valor Mensal</label>
                        <input type="number" step="0.01" class="form-control" name="valor" required>
                    </div>
                    <div class="form-group">
                        <label for="descricao">Descrição (uma por linha)</label>
                        <textarea class="form-control" name="descricao" rows="4"></textarea>
                    </div>
                    <div class="form-group">
                        <label>
                            <input type="checkbox" name="ativo" value="1" checked> Ativo
                        </label>
                    </div>
                    <div class="form-group">
                        <label>
                            <input type="checkbox" name="destaque" value="1"> Destacar
                        </label>
                    </div>
                </div>
                <div class="modal-footer">
                    <button type="button" class="btn btn-secondary" data-dismiss="modal">Cancelar</button>
                    <button type="submit" class="btn btn-primary">Salvar</button>
                </div>
            </form>
        </div>
    </div>
</div>

<!-- Modal Editar Plano -->
<div class="modal fade" id="modalEditarPlano" tabindex="-1" role="dialog">
    <div class="modal-dialog" role="document">
        <div class="modal-content">
            <div class="modal-header">
                <h5 class="modal-title">Editar Plano</h5>
                <button type="button" class="close" data-dismiss="modal">
                    <span>&times;</span>
                </button>
            </div>
            <form id="formEditarPlano" method="POST">
                @csrf
                @method('PUT')
                <div class="modal-body">
                    <input type="hidden" id="edit_plano_id">
                    <div class="form-group">
                        <label for="edit_nome">Nome do Plano</label>
                        <input type="text" class="form-control" id="edit_nome" name="nome" required>
                    </div>
                    <div class="form-group">
                        <label for="edit_valor">Valor Mensal</label>
                        <input type="number" step="0.01" class="form-control" id="edit_valor" name="valor" required>
                    </div>
                    <div class="form-group">
                        <label for="edit_descricao">Descrição</label>
                        <textarea class="form-control" id="edit_descricao" name="descricao" rows="4"></textarea>
                    </div>
                    <div class="form-group">
                        <label>
                            <input type="checkbox" id="edit_ativo" name="ativo" value="1"> Ativo
                        </label>
                    </div>
                    <div class="form-group">
                        <label>
                            <input type="checkbox" id="edit_destaque" name="destaque" value="1"> Destacar
                        </label>
                    </div>
                </div>
                <div class="modal-footer">
                    <button type="button" class="btn btn-secondary" data-dismiss="modal">Cancelar</button>
                    <button type="submit" class="btn btn-primary">Atualizar</button>
                </div>
            </form>
        </div>
    </div>
</div>
@endsection

@push('scripts')
<script>
    $(document).ready(function() {
        $('#datatable1').DataTable({
            responsive: true,
            language: {
                url: '//cdn.datatables.net/plug-ins/1.10.24/i18n/Portuguese-Brasil.json'
            }
        });
    });

    function editarPlano(id, nome, valor, descricao, ativo, destaque) {
        $('#edit_plano_id').val(id);
        $('#edit_nome').val(nome);
        $('#edit_valor').val(valor);
        $('#edit_descricao').val(descricao);
        $('#edit_ativo').prop('checked', ativo == '1');
        $('#edit_destaque').prop('checked', destaque == '1');
        $('#formEditarPlano').attr('action', '/master/planos/' + id);
        $('#modalEditarPlano').modal('show');
    }
</script>
@endpush

