@extends('layouts.app')

@section('title', 'Assinar Plano')

@section('content')
<div class="slim-mainpanel">
    <div class="container">
        <div class="section-wrapper mg-t-20">
            <label class="section-title">
                <i class="fa fa-shopping-cart" aria-hidden="true"></i> Assinar Plano: {{ $plano->nome }}
            </label>
            <hr>

            <div class="row">
                <div class="col-lg-6">
                    <div class="card card-info">
                        <div class="card-header">Detalhes do Plano</div>
                        <div class="card-body">
                            <h4>{{ $plano->nome }}</h4>
                            <h2 class="tx-primary">R$ {{ number_format($plano->valor, 2, ',', '.') }}/mês</h2>
                            
                            @if($plano->descricao)
                            <ul class="mg-t-20">
                                @foreach(explode("\n", $plano->descricao) as $item)
                                    <li>{{ $item }}</li>
                                @endforeach
                            </ul>
                            @endif
                        </div>
                    </div>
                </div>

                <div class="col-lg-6">
                    <div class="card card-info">
                        <div class="card-header">Forma de Pagamento</div>
                        <div class="card-body">
                            <form action="{{ route('planos.comprar', $plano->id) }}" method="POST">
                                @csrf
                                
                                <div class="form-group">
                                    <label>Selecione a forma de pagamento:</label>
                                    <div class="mg-t-10">
                                        <label class="rdiobox">
                                            <input name="forma_pagamento" type="radio" value="pix" checked>
                                            <span>PIX</span>
                                        </label>
                                        <label class="rdiobox">
                                            <input name="forma_pagamento" type="radio" value="boleto">
                                            <span>Boleto</span>
                                        </label>
                                        <label class="rdiobox">
                                            <input name="forma_pagamento" type="radio" value="cartao">
                                            <span>Cartão de Crédito</span>
                                        </label>
                                    </div>
                                </div>

                                <div class="form-group mg-t-20">
                                    <button type="submit" class="btn btn-success btn-block">
                                        <i class="fa fa-check mg-r-5"></i> Confirmar Assinatura
                                    </button>
                                    <a href="{{ route('planos.index') }}" class="btn btn-secondary btn-block">
                                        Voltar
                                    </a>
                                </div>
                            </form>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>
@endsection

