@extends('layouts.app')

@section('title', 'Planos')

@push('styles')
<style>
  .message-box {
    border: 1px solid #000;
    padding: 10px;
    background-color: #ffcccc;
    border-radius: 5px;
    color: #000;
    box-sizing: border-box;
  }

  .btn-spinner {
    width: 18px;
    height: 18px;
    border-radius: 50%;
    border: 2px solid transparent;
    border-top-color: currentColor;
    animation: spin 1s linear infinite;
    display: none;
  }

  .contratar-btn.loading .btn-spinner {
    display: inline-block;
  }

  @keyframes spin {
    to {
      transform: rotate(360deg);
    }
  }
</style>
@endpush

@section('content')
@if(request('msg') == 'solicitacao_enviada')
  <div class="alert alert-success alert-dismissible fade show" role="alert">
    <strong>Sucesso!</strong> Sua solicitação de renovação foi enviada e está em análise.
    <button type="button" class="btn-close" data-bs-dismiss="alert" aria-label="Close"></button>
  </div>
@elseif(request('msg'))
  <div class="alert alert-danger alert-dismissible fade show" role="alert">
    <strong>Erro!</strong> Ocorreu um erro ao processar sua solicitação. Tente novamente.
    <button type="button" class="btn-close" data-bs-dismiss="alert" aria-label="Close"></button>
  </div>
@endif

<div class="dashboard-main-body">
  <div class="d-flex flex-wrap align-items-center justify-content-between gap-3 mb-24">
    <h6 class="fw-semibold text-primary-light mb-0 d-flex align-items-center gap-2">
      <iconify-icon icon="solar:wallet-money-outline" class="text-primary-600 text-xl"></iconify-icon>
      Planos
    </h6>
    <ul class="d-flex align-items-center gap-2 bg-base border border-neutral-200 radius-12 px-16 py-10 shadow-sm">
      <li class="fw-medium">
        <a href="{{ route('dashboard') }}" class="d-flex align-items-center gap-1 hover-text-primary">
          <iconify-icon icon="solar:home-smile-angle-outline" class="icon text-lg"></iconify-icon>
          Dashboard
        </a>
      </li>
      <li>-</li>
      <li class="fw-medium">Planos</li>
    </ul>
  </div>

  <div class="card h-100 p-0 radius-16 overflow-hidden bg-base border border-neutral-200 shadow-sm">
    <div class="card-header border-bottom bg-base py-16 px-24 d-flex justify-content-end align-items-center">
      @if($user->tipo == 1)
        <a href="{{ route('planos.admin') }}" type="button"
          class="btn btn-primary-600 radius-12 px-24 py-14 d-flex align-items-center justify-content-center gap-2 fw-semibold">
          <iconify-icon icon="solar:add-circle-outline" class="text-xl line-height-1"></iconify-icon>
          NOVO PLANO
        </a>
      @endif
    </div>
    <div class="card-body p-40">
      <div class="row justify-content-center mt-28 pt-28">
        <div class="col-xxl-10">
          <div class="tab-content" id="pills-tabContent">
            <div class="tab-pane fade show active" id="pills-monthly" role="tabpanel"
              aria-labelledby="pills-monthly-tab" tabindex="0">
              <div class="row gy-4">
                @foreach($planos as $plano)
                  @php
                    $value = $plano->valor;
                    $values = explode('.', number_format($value, 2, '.', ''));
                    $popular = ($plano->nome == 'Semestral');
                  @endphp
                  <div class="col-xxl-4 col-sm-6 pricing-plan-wrapper">
                    <div class="pricing-plan position-relative radius-24 overflow-hidden border bg-base text-secondary-light shadow-sm">
                      @if($popular)
                        <span class="badge bg-success-100 text-success-600 radius-pill py-8 px-24 text-sm position-absolute end-0 top-0 z-1 rounded-start-top-0 rounded-end-bottom-0">Popular</span>
                      @endif
                      @if($user->tipo == 1)
                        <div class="d-flex justify-content-end gap-12 position-absolute end-0 z-1 p-16" style="top: 20px;">
                          <form action="{{ route('planos.admin') }}" method="get" class="edit">
                            <input type="hidden" name="edit" value="{{ $plano->id }}">
                            <button type="submit" class="btn btn-outline-neutral-400 btn-sm radius-8"><i class="fa fa-edit"></i></button>
                          </form>
                          <form action="{{ route('planos.destroy', $plano->id) }}" method="post" class="delete">
                            @csrf
                            @method('DELETE')
                            <button type="submit" class="btn btn-outline-danger-600 btn-sm radius-8" onclick="return confirm('Tem certeza que deseja excluir este plano?')"><i class="fa fa-trash"></i></button>
                          </form>
                        </div>
                      @endif
                      <div class="d-flex align-items-center gap-16">
                        <span class="w-72-px h-72-px d-flex justify-content-center align-items-center radius-16 bg-neutral-100">
                          <i class="fa-solid fa-circle-half-stroke text-success-600" style="font-size: xx-large;"></i>
                        </span>
                        <div>
                          <span class="fw-medium text-md text-secondary-light text-uppercase letter-spacing-1">Plano</span>
                          <h6 class="mb-0 text-primary-light">
                            {{ $plano->nome }}
                          </h6>
                        </div>
                      </div>
                      <p class="mb-1 text-secondary-light text-sm">
                        Limite de Cadastros: <strong>{{ $plano->cadastros_lim ?: '∞' }}</strong>
                      </p>
                      <p class="mb-1 text-secondary-light text-sm">
                        Instâncias WhatsApp: <strong>{{ is_null($plano->instancias_limite) ? '∞' : $plano->instancias_limite }}</strong>
                      </p>
                      <p class="mt-16 mb-28 text-secondary-light text-sm">
                        Pague via Pix ou Cartão de Crédito.
                      </p>
                      <h4 class="mb-24 text-primary-light">
                        R$ {{ $values[0] }},{{ $values[1] }} <span class="fw-medium text-md text-secondary-light">/{{ $plano->nome }}</span>
                      </h4>

                      @if($user->tipo == 2)
                        @php
                          $podRenovarGratis = ($saldoDisponivel >= $plano->valor);
                        @endphp

                        @if($podRenovarGratis)
                          <div class="alert alert-success-100 border border-success-200 text-sm text-secondary-light text-center radius-12 mb-16">
                            <strong class="text-success-600 d-block mb-4">🎁 Você pode renovar GRÁTIS!</strong>
                            Saldo: R$ {{ number_format($saldoDisponivel, 2, ',', '.') }}
                          </div>

                          <button type="button" onclick="renovarComSaldo({{ $plano->id }}, {{ $plano->valor }}, '{{ $plano->nome }}')"
                            class="btn btn-success-600 text-white text-center text-sm btn-sm px-12 py-10 w-100 radius-12 mt-12 d-flex align-items-center justify-content-center gap-2">
                            <iconify-icon icon="solar:wallet-check-outline" class="me-1"></iconify-icon>
                            RENOVAR GRÁTIS COM SALDO
                          </button>

                          <small class="d-block text-center mt-2 text-secondary-light" style="font-size: 11px;">
                            Saldo restante: R$ {{ number_format($saldoDisponivel - $plano->valor, 2, ',', '.') }}
                          </small>
                        @else
                          @if($tem_mp)
                            <a href="#" id="wallet_container_{{ $plano->id }}" class="w-100 contratar-btn"
                              data-valor="{{ $plano->valor }}" data-id="{{ $plano->id }}"
                              data-nome="{{ $plano->nome }}">
                              <button type="button"
                                class="btn btn-outline-primary-600 text-sm btn-sm px-12 py-10 w-100 radius-12 mt-16 d-flex align-items-center justify-content-center gap-2">
                                <span class="button-text">CONTRATAR</span>
                                <span class="btn-spinner"></span>
                              </button>
                            </a>
                          @else
                            <form action="#" method="post">
                              @csrf
                              <input type="hidden" name="solicitar_renovacao" value="1">
                              <input type="hidden" name="plano_id" value="{{ $plano->id }}">
                              <button type="submit"
                                class="btn btn-outline-neutral-400 text-sm btn-sm px-12 py-10 w-100 radius-12 mt-16">
                                SOLICITAR RENOVAÇÃO
                              </button>
                            </form>
                          @endif

                          @if($saldoDisponivel > 0 && $saldoDisponivel < $plano->valor)
                            <small class="d-block text-center mt-2 text-info-600" style="font-size: 11px;">
                              <iconify-icon icon="solar:info-circle-outline"></iconify-icon>
                              Acumule mais R$ {{ number_format($plano->valor - $saldoDisponivel, 2, ',', '.') }} e renove grátis!
                            </small>
                          @endif
                        @endif
                      @endif
                    </div>
                  </div>
                @endforeach
              </div>
            </div>
          </div>
        </div>
      </div>
    </div>
  </div>
</div>

<!-- Modal Confirmação de Renovação com Saldo -->
<div class="modal fade" id="modalRenovarSaldo" tabindex="-1" aria-hidden="true">
  <div class="modal-dialog modal-dialog-centered">
    <div class="modal-content radius-16 bg-base">
      <div class="modal-header border-bottom">
        <h6 class="modal-title text-success d-flex align-items-center">
          <iconify-icon icon="solar:wallet-check-outline" class="me-2 text-xl"></iconify-icon>
          Renovação Grátis com Saldo
        </h6>
        <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
      </div>
      <div class="modal-body p-24">
        <div class="text-center mb-24">
          <div class="w-80-px h-80-px bg-success-focus rounded-circle d-flex align-items-center justify-content-center mx-auto mb-16">
            <iconify-icon icon="solar:gift-outline" class="text-success" style="font-size: 48px;"></iconify-icon>
          </div>
          <h5 class="mb-8">Renovação 100% Grátis!</h5>
          <p class="mb-16 text-secondary-light text-sm">Use seu saldo de indicação para renovar</p>
        </div>
        
        <div class="bg-success-focus p-16 radius-8 mb-16">
          <div class="d-flex justify-content-between mb-8">
            <span class="text-secondary-light">Plano:</span>
            <strong id="modal_plano_nome">-</strong>
          </div>
          <div class="d-flex justify-content-between mb-8">
            <span class="text-secondary-light">Valor do plano:</span>
            <strong class="text-danger">- R$ <span id="modal_valor_plano">0,00</span></strong>
          </div>
          <div class="d-flex justify-content-between mb-8">
            <span class="text-secondary-light">Seu saldo atual:</span>
            <strong class="text-success">R$ <span id="modal_saldo_atual">{{ number_format($saldoDisponivel, 2, ',', '.') }}</span></strong>
          </div>
          <hr class="my-8">
          <div class="d-flex justify-content-between">
            <span class="fw-semibold">Saldo restante:</span>
            <strong class="text-success">R$ <span id="modal_saldo_restante">0,00</span></strong>
          </div>
        </div>
        
        <div class="alert alert-info d-flex align-items-start">
          <iconify-icon icon="solar:info-circle-outline" class="me-2 text-xl flex-shrink-0 mt-1"></iconify-icon>
          <div>
            <small>Sua assinatura será renovada automaticamente sem custo adicional. O valor será debitado do seu saldo de indicações.</small>
          </div>
        </div>
      </div>
      <div class="modal-footer border-top">
        <button type="button" class="btn btn-outline-neutral-400 radius-8 px-20 py-11" data-bs-dismiss="modal">
          Cancelar
        </button>
        <button type="button" class="btn btn-success-600 radius-8 px-20 py-11 d-flex align-items-center gap-2" id="btnConfirmarRenovacao">
          <iconify-icon icon="solar:check-circle-outline"></iconify-icon>
          Confirmar Renovação Grátis
        </button>
      </div>
    </div>
  </div>
</div>
@endsection

@push('scripts')
@if($tem_mp && isset($dadosAdmin) && $dadosAdmin->publicmp)
<script src="https://sdk.mercadopago.com/js/v2"></script>
<script>
  const mp = new MercadoPago('{{ $dadosAdmin->publicmp }}', {
    locale: 'pt-BR'
  });
  console.log('DEBUG: MP inicializado com sucesso');
</script>
@else
<script>
  console.log('DEBUG: MP não inicializado - tem_mp=false');
</script>
@endif

<script src="https://code.jquery.com/jquery-3.5.1.min.js"></script>
<script src="https://cdnjs.cloudflare.com/ajax/libs/toastr.js/latest/toastr.min.js"></script>
<link href="https://cdnjs.cloudflare.com/ajax/libs/toastr.js/latest/toastr.min.css" rel="stylesheet" />
<script>
  // VARIÁVEIS GLOBAIS PARA O MODAL
  let renovacaoPlanoId, renovacaoValorPlano, renovacaoNomePlano;
  
  // FUNÇÃO PARA ABRIR MODAL DE RENOVAÇÃO COM SALDO
  function renovarComSaldo(planoId, valorPlano, nomePlano) {
    // Armazenar dados
    renovacaoPlanoId = planoId;
    renovacaoValorPlano = valorPlano;
    renovacaoNomePlano = nomePlano;
    
    // Calcular saldo restante
    const saldoAtual = {{ $saldoDisponivel }};
    const saldoRestante = saldoAtual - valorPlano;
    
    // Preencher modal
    document.getElementById('modal_plano_nome').innerText = nomePlano;
    document.getElementById('modal_valor_plano').innerText = valorPlano.toFixed(2).replace('.', ',');
    document.getElementById('modal_saldo_restante').innerText = saldoRestante.toFixed(2).replace('.', ',');
    
    // Abrir modal
    const modal = new bootstrap.Modal(document.getElementById('modalRenovarSaldo'));
    modal.show();
  }
  
  // CONFIGURAR TOASTR
  toastr.options = {
    "closeButton": true,
    "progressBar": true,
    "positionClass": "toast-top-right",
    "timeOut": "4000",
    "extendedTimeOut": "1000"
  };
  
  // CONFIRMAR RENOVAÇÃO (ao clicar no botão do modal)
  document.getElementById('btnConfirmarRenovacao')?.addEventListener('click', function() {
    const btn = this;
    btn.disabled = true;
    btn.innerHTML = '<span class="btn-spinner me-2"></span>Processando...';
    
    // TODO: Implementar chamada AJAX para renovar_com_saldo
    fetch('/master/api/renovar_com_saldo.php', {
      method: 'POST',
      headers: {
        'Content-Type': 'application/json',
        'X-CSRF-TOKEN': '{{ csrf_token() }}'
      },
      body: JSON.stringify({
        plano_id: renovacaoPlanoId,
        valor_plano: renovacaoValorPlano,
        nome_plano: renovacaoNomePlano
      })
    })
    .then(response => response.json())
    .then(data => {
      if (data.success) {
        const modal = bootstrap.Modal.getInstance(document.getElementById('modalRenovarSaldo'));
        modal.hide();
        
        toastr.success(
          'Nova data: ' + data.nova_data + '<br>' +
          'Saldo restante: R$ ' + data.saldo_restante.toFixed(2).replace('.', ','),
          '🎉 ' + data.message,
          {timeOut: 5000}
        );
        
        setTimeout(function() {
          window.location.reload();
        }, 2000);
      } else {
        toastr.error(data.message, 'Erro ao renovar');
        btn.disabled = false;
        btn.innerHTML = '<iconify-icon icon="solar:check-circle-outline"></iconify-icon> Confirmar Renovação Grátis';
      }
    })
    .catch(error => {
      console.error('Erro:', error);
      toastr.error('Erro ao processar renovação. Tente novamente.', 'Erro');
      btn.disabled = false;
      btn.innerHTML = '<iconify-icon icon="solar:check-circle-outline"></iconify-icon> Confirmar Renovação Grátis';
    });
  });

  // CONTRATAR COM MERCADO PAGO
  @if($tem_mp && isset($dadosAdmin) && $dadosAdmin->publicmp)
  $(document).ready(function () {
    $('.contratar-btn').click(function (e) {
      e.preventDefault();
      const $button = $(this);

      // Prevent double clicks
      if ($button.hasClass('loading')) return;

      // Show loading state
      $button.addClass('loading');

      var value = $button.data('valor');
      var planId = $button.data('id');
      var planName = $button.data('nome');

      $.post('/master/create_payment.php', {
        value: value,
        planId: planId,
        planName: planName,
        cod_id: {{ $user->id }}
      })
        .done(function (preferenceId) {
          console.log('preferenceId:', preferenceId);
          const containerId = '#wallet_container_' + planId;
          if (document.querySelector(containerId)) {
            mp.checkout({
              preference: {
                id: preferenceId
              },
              render: {
                container: containerId,
                label: 'Pagar',
              },
              autoOpen: true,
              onReady: function () {
                $button.removeClass('loading');
                $('.btn-contratar').hide();
              },
              onError: (error) => {
                console.error('onError:', error);
                $button.removeClass('loading');
                alert('Ocorreu um erro ao processar o pagamento. Por favor, tente novamente.');
              }
            });
          }
        })
        .fail(function (error) {
          console.error('Error:', error);
          $button.removeClass('loading');
          alert('Ocorreu um erro ao processar o pagamento. Por favor, tente novamente.');
        });
    });
  });
  @endif
</script>
@endpush
