@extends('layouts.app')

@section('title', 'Novo Usuário SAAS')

@section('content')
<div class="slim-mainpanel">
    <div class="container">
        <div align="right" class="mg-b-10">
            <a href="{{ route('usuarios.index') }}" class="btn btn-purple btn-sm">VOLTAR</a>
        </div>

        <div class="row">
            <div class="col-md-12">
                <div class="card card-info">
                    <div class="card-body" align="justify">
                        <label class="section-title">
                            <i class="fa fa-user-plus" aria-hidden="true"></i>
                            CADASTRO DE USUÁRIO SAAS
                        </label>
                        <hr>

                        <form action="{{ route('usuarios.store') }}" method="POST">
                            @csrf

                            <div class="row">
                                <div class="col-md-4">
                                    <div class="form-group">
                                        <label>Nome Completo <span class="tx-danger">*</span></label>
                                        <input type="text" class="form-control" name="nome" value="{{ old('nome') }}" maxlength="120" required>
                                        @error('nome')
                                            <span class="text-danger">{{ $message }}</span>
                                        @enderror
                                    </div>
                                </div>

                                <div class="col-md-2">
                                    <div class="form-group">
                                        <label>Celular/WhatsApp <span class="tx-danger">*</span></label>
                                        <input type="text" class="form-control" name="celular" value="{{ old('celular') }}" maxlength="11" required>
                                        @error('celular')
                                            <span class="text-danger">{{ $message }}</span>
                                        @enderror
                                    </div>
                                </div>

                                <div class="col-md-2">
                                    <div class="form-group">
                                        <label>LOGIN (E-mail) <span class="tx-danger">*</span></label>
                                        <input type="email" class="form-control" name="login" value="{{ old('login') }}" required>
                                        @error('login')
                                            <span class="text-danger">{{ $message }}</span>
                                        @enderror
                                    </div>
                                </div>

                                <div class="col-md-2">
                                    <div class="form-group">
                                        <label>Senha <span class="tx-danger">*</span></label>
                                        <input type="password" class="form-control" name="senha" required>
                                        @error('senha')
                                            <span class="text-danger">{{ $message }}</span>
                                        @enderror
                                    </div>
                                </div>

                                <div class="col-md-2">
                                    <div class="form-group">
                                        <label>Assinatura <span class="tx-danger">*</span></label>
                                        <input type="text" class="form-control" id="dateMask" name="assinatura" value="{{ old('assinatura') }}" placeholder="DD/MM/AAAA" maxlength="10" required>
                                        @error('assinatura')
                                            <span class="text-danger">{{ $message }}</span>
                                        @enderror
                                    </div>
                                </div>
                            </div>

                            <hr />

                            <div class="row">
                                <div class="col-md-12">
                                    <div align="center">
                                        <button type="submit" class="btn btn-primary">
                                            Salvar <i class="fa fa-arrow-right"></i>
                                        </button>
                                    </div>
                                </div>
                            </div>
                        </form>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>
@endsection

@push('scripts')
<script src="{{ asset('lib/jquery.maskedinput/js/jquery.maskedinput.js') }}"></script>
<script>
    $(function() {
        'use strict';
        $('#dateMask').mask('00/00/0000');
    });
</script>
@endpush

