@extends('layouts.app')

@section('title', 'Usuários SAAS')

@push('styles')
<style>
/* Container de fundo para o breadcrumb */
.d-flex.flex-wrap.align-items-center.justify-content-between.gap-3.mb-24 ul.d-flex.align-items-center.gap-2 {
    background: rgba(255, 255, 255, 0.1);
    backdrop-filter: blur(10px);
    border: 1px solid rgba(255, 255, 255, 0.1);
    border-radius: 12px;
    padding: 12px 20px;
    box-shadow: 0 4px 16px rgba(0, 0, 0, 0.1);
}
</style>
@endpush

@section('content')
<div class="dashboard-main-body">
    <div class="d-flex flex-wrap align-items-center justify-content-between gap-3 mb-24">
        <h6 class="fw-semibold mb-0">Gestão de Usuários</h6>
        <ul class="d-flex align-items-center gap-2">
            <li class="fw-medium">
                <a href="{{ route('dashboard') }}" class="d-flex align-items-center gap-1 hover-text-primary">
                    <iconify-icon icon="solar:home-smile-angle-outline" class="icon text-lg"></iconify-icon>
                    Dashboard
                </a>
            </li>
            <li>-</li>
            <li class="fw-medium">Usuários SaaS</li>
        </ul>
    </div>

    <div class="card basic-data-table">
        <div class="row gy-4">
            <!-- Primeira linha de cards -->
            <div class="col-xxl-12">
                <div class="card">
                    <div class="card-body p-20">
                        <div class="row g-3">
                            <div class="col-sm-4 col-xs-3">
                                <div class="radius-8 h-100 text-center p-20 bg-info-500">
                                    <span class="w-44-px h-44-px radius-8 d-inline-flex justify-content-center align-items-center text-xl mb-12 bg-info-200 border border-info-400 text-info-700">
                                        <i class="fa fa-users mr-3"></i>
                                    </span>
                                    <span class="text-neutral-500 d-block">Total de Usuários</span>
                                    <h6 class="mb-0 mt-4 text-neutral-500">{{ $total_usuarios }}</h6>
                                </div>
                            </div>
                            <div class="col-sm-4 col-xs-3">
                                <div class="radius-8 h-100 text-center p-20 bg-success-100">
                                    <span class="w-44-px h-44-px radius-8 d-inline-flex justify-content-center align-items-center text-xl mb-12 bg-success-200 border border-success-400 text-success-600">
                                        <i class="fa fa-check-circle mr-3"></i>
                                    </span>
                                    <span class="text-neutral-500 d-block">Pagamentos Aprovados</span>
                                    <h6 class="mb-0 mt-4 text-neutral-500">{{ $total_aprovados }}</h6>
                                </div>
                            </div>
                            <div class="col-sm-4 col-xs-3">
                                <div class="radius-8 h-100 text-center p-20 bg-warning-100">
                                    <span class="w-44-px h-44-px radius-8 d-inline-flex justify-content-center align-items-center text-xl mb-12 bg-warning-200 border border-warning-400 text-warning-600">
                                        <i class="fa fa-user-check mr-3"></i>
                                    </span>
                                    <span class="text-neutral-500 d-block">Usuários Ativos</span>
                                    <h6 class="mb-0 mt-4 text-neutral-500">{{ $usuariosAtivos }}</h6>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>

            <!-- Segunda linha de cards -->
            <div class="col-xxl-12">
                <div class="card">
                    <div class="card-body p-20">
                        <div class="row g-3">
                            <div class="col-sm-3 col-xs-6">
                                <div class="radius-8 h-100 text-center p-20 bg-purple-100">
                                    <span class="w-44-px h-44-px radius-8 d-inline-flex justify-content-center align-items-center text-xl mb-12 bg-purple-200 border border-purple-400 text-purple-600">
                                        <i class="fab fa-whatsapp mr-3"></i>
                                    </span>
                                    <span class="text-neutral-500 d-block">Com WhatsApp</span>
                                    <h6 class="mb-0 mt-4 text-neutral-500">{{ $total_com_whatsapp }}</h6>
                                </div>
                            </div>
                            <div class="col-sm-3 col-xs-6">
                                <div class="radius-8 h-100 text-center p-20 bg-success-100">
                                    <span class="w-44-px h-44-px radius-8 d-inline-flex justify-content-center align-items-center text-xl mb-12 bg-success-200 border border-success-400 text-success-600">
                                        <i class="fas fa-qrcode mr-3"></i>
                                    </span>
                                    <span class="text-neutral-500 d-block">Com PIX</span>
                                    <h6 class="mb-0 mt-4 text-neutral-500">{{ $total_com_pix }}</h6>
                                </div>
                            </div>
                            <div class="col-sm-3 col-xs-6">
                                <div class="radius-8 h-100 text-center p-20 bg-info-100">
                                    <span class="w-44-px h-44-px radius-8 d-inline-flex justify-content-center align-items-center text-xl mb-12 bg-info-200 border border-info-400 text-info-600">
                                        <i class="fas fa-credit-card mr-3"></i>
                                    </span>
                                    <span class="text-neutral-500 d-block">Com MercadoPago</span>
                                    <h6 class="mb-0 mt-4 text-neutral-500">{{ $total_com_mercadopago }}</h6>
                                </div>
                            </div>
                            <div class="col-sm-3 col-xs-6">
                                <div class="radius-8 h-100 text-center p-20 bg-danger-100">
                                    <span class="w-44-px h-44-px radius-8 d-inline-flex justify-content-center align-items-center text-xl mb-12 bg-danger-200 border border-danger-400 text-danger-600">
                                        <i class="fas fa-percentage mr-3"></i>
                                    </span>
                                    <span class="text-neutral-500 d-block">Taxa Média</span>
                                    <h6 class="mb-0 mt-4 text-neutral-500">{{ number_format($media_juros, 2, ',', '.') }}%</h6>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>

        <div class="card-header" style="display: flex; justify-content: space-between; align-items: center;">
            <div class="mg-b-10 d-flex gap-1 w-100 justify-content-end">
                <button onclick="addUsuarioModalShow()" type="button" class="fw-semibold text-lilac-600 py-16 px-24 border radius-12 text-md d-flex align-items-center justify-content-center gap-12 line-height-1 bg-hover-lilac-50">
                    <iconify-icon icon="tabler:plus" class="text-lilac-600 text-xl line-height-1"></iconify-icon>
                    NOVO USUÁRIO
                </button>
            </div>
        </div>

        <div class="card-body table-responsive">
            <table class="table bordered-table mb-0 display responsive nowrap w-100" id="usuariosTable" data-page-length='10'>
                <thead>
                    <tr>
                        <th style="text-align: left;">#</th>
                        <th style="text-align: left;">Nome</th>
                        <th style="text-align: left;">Celular</th>
                        <th style="text-align: left;">Login</th>
                        <th style="text-align: left;">Assinatura</th>
                        <th style="text-align: center;">Ações</th>
                    </tr>
                </thead>
                <tbody>
                    @if(isset($usuarios) && $usuarios->count() > 0)
                        @foreach($usuarios as $usuario)
                        <tr>
                            <td style="text-align: left;">{{ $usuario->id ?? '-' }}</td>
                            <td style="text-align: left;">{{ $usuario->nome ?? '-' }}</td>
                            <td style="text-align: left;">{{ $usuario->celular ?? '-' }}</td>
                            <td style="text-align: left;">{{ $usuario->login ?? '-' }}</td>
                            <td style="text-align: left;">{{ $usuario->assinatura ?? '-' }}</td>
                            <td align="center">
                                <div class="d-flex justify-content-center gap-2">
                                    <a href="{{ route('usuarios.show', $usuario->id) }}" class="btn btn-info btn-sm" title="Ver detalhes">
                                        <i class="icon fa fa-search"></i>
                                    </a>
                                    <a href="{{ route('usuarios.edit', $usuario->id) }}" class="btn btn-warning btn-sm" title="Editar">
                                        <i class="icon fa fa-pencil-square"></i>
                                    </a>
                                    <form action="{{ route('usuarios.destroy', $usuario->id) }}" method="POST" style="display: inline;" onsubmit="return confirm('Tem certeza que deseja excluir este usuário?');">
                                        @csrf
                                        @method('DELETE')
                                        <button type="submit" class="btn btn-danger btn-sm" title="Excluir">
                                            <i class="icon fa fa-times"></i>
                                        </button>
                                    </form>
                                </div>
                            </td>
                        </tr>
                        @endforeach
                    @else
                        <tr>
                            <td colspan="6" class="text-center text-muted py-4">
                                Nenhum usuário encontrado.
                            </td>
                        </tr>
                    @endif
                </tbody>
            </table>
        </div>
    </div>
</div>
@endsection

@push('scripts')
<script src="https://cdn.datatables.net/plug-ins/1.13.6/sorting/date-eu.js"></script>
<script>
    $(document).ready(function() {
        // Aguardar um pouco para garantir que o DOM está totalmente carregado
        setTimeout(function() {
            if ($.fn.DataTable.isDataTable('#usuariosTable')) {
                $('#usuariosTable').DataTable().destroy();
            }
            
            // Verificar se a tabela tem dados válidos (sem colspan)
            var table = $('#usuariosTable');
            var tbody = table.find('tbody');
            var rows = tbody.find('tr');
            var hasValidData = false;
            
            // Remover linha com colspan antes de inicializar DataTables
            rows.each(function() {
                var $row = $(this);
                var $td = $row.find('td[colspan]');
                if ($td.length > 0) {
                    $row.remove(); // Remove linha com colspan
                } else {
                    var tdCount = $row.find('td').length;
                    // Se a linha tem 6 colunas, tem dados válidos
                    if (tdCount === 6) {
                        hasValidData = true;
                    }
                }
            });
            
            // Só inicializar se houver dados válidos
            if (hasValidData) {
                let table = new DataTable("#usuariosTable", {
                    responsive: true,
                    order: [[4, "desc"]],
                    pageLength: 10,
                    columnDefs: [
                        {
                            targets: 4,
                            type: "date-eu"
                        },
                        { orderable: false, targets: -1 } // Desabilitar ordenação na última coluna (Ações)
                    ],
                    language: {
                        url: '//cdn.datatables.net/plug-ins/1.10.24/i18n/Portuguese-Brasil.json'
                    }
                });
            }
        }, 100);
    });

    function addUsuarioModalShow() {
        window.location.href = '{{ route("usuarios.create") }}';
    }
</script>
@endpush
