@extends('layouts.app')

@section('title', 'Painel do Usuário')

@section('content')
<div class="slim-mainpanel">
    <div class="container">
        <div class="section-wrapper mg-t-20">
            <div class="row mg-b-20">
                <div class="col-lg-6">
                    <label class="section-title">
                        <i class="fa fa-user" aria-hidden="true"></i> Painel do Usuário
                    </label>
                </div>
                <div class="col-lg-6 text-right">
                    <a href="{{ route('usuarios.edit', $usuario->id) }}" class="btn btn-warning btn-sm">
                        <i class="fa fa-pencil mg-r-5"></i> Editar
                    </a>
                    <a href="{{ route('usuarios.index') }}" class="btn btn-secondary btn-sm">
                        <i class="fa fa-arrow-left mg-r-5"></i> Voltar
                    </a>
                </div>
            </div>
            <hr>

            <div class="row">
                <div class="col-lg-6">
                    <div class="card card-info">
                        <div class="card-header">Informações do Usuário</div>
                        <div class="card-body">
                            <p><strong>ID:</strong> {{ $usuario->id }}</p>
                            <p><strong>Nome:</strong> {{ $usuario->nome }}</p>
                            <p><strong>Celular:</strong> {{ $usuario->celular }}</p>
                            <p><strong>Login:</strong> {{ $usuario->login }}</p>
                            <p><strong>Tipo:</strong> 
                                @if($usuario->tipo == '2')
                                    Revendedor
                                @else
                                    Cliente
                                @endif
                            </p>
                            <p><strong>Status:</strong> 
                                @if($usuario->status == '1')
                                    <span class="badge badge-success">Ativo</span>
                                @else
                                    <span class="badge badge-danger">Inativo</span>
                                @endif
                            </p>
                            <p><strong>Assinatura:</strong> {{ $usuario->assinatura }}</p>
                            <p><strong>Cadastrado em:</strong> {{ $usuario->created_at->format('d/m/Y') }}</p>
                        </div>
                    </div>
                </div>

                <div class="col-lg-6">
                    <div class="card card-info">
                        <div class="card-header">Estatísticas</div>
                        <div class="card-body">
                            <div class="row">
                                <div class="col-6">
                                    <div class="info-box">
                                        <h3 class="tx-primary">{{ $totalClientes }}</h3>
                                        <p class="mg-b-0">Clientes</p>
                                    </div>
                                </div>
                                <div class="col-6">
                                    <div class="info-box">
                                        <h3 class="tx-success">{{ $totalCobrancas }}</h3>
                                        <p class="mg-b-0">Cobranças</p>
                                    </div>
                                </div>
                            </div>
                            <div class="row mg-t-20">
                                <div class="col-12">
                                    <div class="info-box">
                                        <h3 class="tx-teal">R$ {{ number_format($totalRecebido, 2, ',', '.') }}</h3>
                                        <p class="mg-b-0">Total Recebido</p>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>

            <div class="row mg-t-20">
                <div class="col-lg-12">
                    <div class="card card-info">
                        <div class="card-header">Ações Rápidas</div>
                        <div class="card-body">
                            <a href="{{ route('usuarios.edit', $usuario->id) }}" class="btn btn-warning">
                                <i class="fa fa-pencil mg-r-5"></i> Editar Dados
                            </a>
                            
                            @if($usuario->status == '1')
                            <button class="btn btn-danger" onclick="alert('Funcionalidade de desativar será implementada')">
                                <i class="fa fa-ban mg-r-5"></i> Desativar Usuário
                            </button>
                            @else
                            <button class="btn btn-success" onclick="alert('Funcionalidade de ativar será implementada')">
                                <i class="fa fa-check mg-r-5"></i> Ativar Usuário
                            </button>
                            @endif

                            <button class="btn btn-info" onclick="alert('Funcionalidade de renovar assinatura será implementada')">
                                <i class="fa fa-refresh mg-r-5"></i> Renovar Assinatura
                            </button>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>

@push('styles')
<style>
.info-box {
    text-align: center;
    padding: 20px;
}
.info-box h3 {
    font-size: 32px;
    margin-bottom: 5px;
}
</style>
@endpush
@endsection

