@extends('layouts.app')

@section('title', 'Editar Vídeo')

@section('content')
<div class="slim-mainpanel">
    <div class="container">
        <div class="row">
            <div class="col-md-8 offset-md-2">
                <div class="card">
                    <div class="card-header">
                        <i class="fa fa-pencil mg-r-5"></i> Editar Vídeo
                    </div>
                    <div class="card-body">
                        <form method="POST" action="{{ route('videos.update', $video->id) }}">
                            @csrf
                            @method('PUT')
                            
                            <div class="form-group">
                                <label for="title">Título do Vídeo <span class="tx-danger">*</span></label>
                                <input type="text" name="title" id="title" class="form-control"
                                    value="{{ old('title', $video->title) }}" required>
                            </div>
                            
                            <div class="form-group">
                                <label for="link">Código do Vídeo <span class="tx-danger">*</span></label>
                                <input type="text" name="link" id="link" class="form-control"
                                    value="{{ old('link', $video->link) }}" required>
                                <small class="form-text text-muted">
                                    Para o vídeo 'https://youtu.be/i6gEcyFmJDc', o código é 'i6gEcyFmJDc'
                                </small>
                            </div>
                            
                            <div class="form-group mg-t-20">
                                <button type="submit" class="btn btn-success">
                                    <i class="fa fa-check mg-r-5"></i> Salvar
                                </button>
                                <a href="{{ route('videos.index') }}" class="btn btn-secondary">
                                    <i class="fa fa-arrow-left mg-r-5"></i> Voltar
                                </a>
                            </div>
                        </form>
                        
                        {{-- Preview do vídeo --}}
                        <hr>
                        <div class="form-group">
                            <label>Preview:</label>
                            <iframe width="100%" height="400" 
                                src="https://www.youtube.com/embed/{{ $video->link }}" 
                                frameborder="0"
                                allow="accelerometer; autoplay; clipboard-write; encrypted-media; gyroscope; picture-in-picture"
                                allowfullscreen>
                            </iframe>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>
@endsection

